/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.debtor;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.reports.CSVExportAction;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.SystemProperty;
import ordermate.database.reports.debtor.DebtorSalesItemReport;
import ordermate.database.searchers.reports.debtor.DebtorSalesItemReportSearcher;
import ordermate.database.users.Permission;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.ColumnVisibilityHelper;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class DebtorSalesItemTableState
extends AbstractTableState<DebtorSalesItemReport> {
    private JCheckBox showCOGSCheckBox;
    private RefreshAction refreshAction = new RefreshAction((Refreshable)this);
    private DebtorSalesItemReportSearcher searcher;

    public DebtorSalesItemTableState(Permission permission) {
        super("Search", permission, "The table of debtor sales items.");
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        new ColumnVisibilityHelper((Object[])new PropertiedObject.Property[]{DebtorSalesItemReport.Properties.COGS, DebtorSalesItemReport.Properties.COGS_PERC}, this.showCOGSCheckBox, this.getCentralArea().getTable());
    }

    @Override
    public void onStart() {
        super.onStart();
        this.showCOGSCheckBox.setSelected(SystemProperty.getInstance().isStockControlEnabled());
    }

    @Override
    protected OfficeMateObjectSearch<DebtorSalesItemReport> createSearchPanelFactory() {
        this.getSearcher();
        ObjectPropertySearch<DebtorSalesItemReport> search = new ObjectPropertySearch<DebtorSalesItemReport>(DebtorSalesItemReport.class, (ObjectQuerySearcher<DebtorSalesItemReport>)this.searcher, (EventList<DebtorSalesItemReport>)new BasicEventList());
        DateRangeSearchField field = new DateRangeSearchField("Between", (IRangedQuerySearchFilter)this.searcher.getDateFilter(), new Date(), (Action)this.refreshAction);
        search.addSearchField((SearchGuiField)field);
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Shift", (Action)this.refreshAction, GlazedLists.eventList((Collection)ConfigShift.getAllConfigShifts()), null, (MultiOptionSearchFilter)this.searcher.getShiftConfigFilter(), new JCheckBoxCellRenderer()));
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Sales Location", this.searcher.getSalesLocationFilter(), (Action)this.refreshAction, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations())));
        search.useSearchRefreshStrategy();
        FieldPanelBuilder builder = new FieldPanelBuilder();
        JPanel additionalFields = new JPanel();
        additionalFields.setLayout(new BoxLayout(additionalFields, 1));
        this.showCOGSCheckBox = new JCheckBox((Action)this.refreshAction);
        this.showCOGSCheckBox.setText("");
        this.showCOGSCheckBox.setName("showCOGSCheckBox");
        builder.addRow("Show COGS", (Component)this.showCOGSCheckBox);
        additionalFields.add(builder.getPanel());
        search.addToSearchPanel(additionalFields);
        return search;
    }

    @Override
    protected TableStateCentralArea<DebtorSalesItemReport> createCentralArea() {
        ColumnFormat[] columns = this.getDefaultCSVColumns();
        ColumnTableFormat format = new ColumnTableFormat(columns);
        this.addAction(new CSVExportAction(this.getObjectList(), columns, "Debtor Sales Items.csv"));
        PersistentObjectTable<DebtorSalesItemReport> table = new PersistentObjectTable<DebtorSalesItemReport>(this.getObjectList(), format);
        return table;
    }

    @Override
    protected Class<DebtorSalesItemReport> getDisplayingType() {
        return DebtorSalesItemReport.class;
    }

    public ColumnFormat[] getDefaultCSVColumns() {
        List<ColumnFormat> cols = Arrays.asList(new PropertyColumnFormat((PropertiedObject.Property)DebtorSalesItemReport.Properties.DEBTOR_GROUP), new PropertyColumnFormat(DebtorSalesItemReport.Properties.DEBTOR), new PropertyColumnFormat((PropertiedObject.Property)DebtorSalesItemReport.Properties.PURCHASE_DATE), new PropertyColumnFormat((PropertiedObject.Property)DebtorSalesItemReport.Properties.SALES_ITEM), new PropertyColumnFormat((PropertiedObject.Property)DebtorSalesItemReport.Properties.PRICE_EX), new PropertyColumnFormat((PropertiedObject.Property)DebtorSalesItemReport.Properties.TAX), new PropertyColumnFormat((PropertiedObject.Property)DebtorSalesItemReport.Properties.PRICE_INC), new PropertyColumnFormat((PropertiedObject.Property)DebtorSalesItemReport.Properties.QUANTITY), new PropertyColumnFormat((PropertiedObject.Property)DebtorSalesItemReport.Properties.TOTAL_EX), new PropertyColumnFormat((PropertiedObject.Property)DebtorSalesItemReport.Properties.TOTAL_TAX), new PropertyColumnFormat((PropertiedObject.Property)DebtorSalesItemReport.Properties.TOTAL_INC), new PropertyColumnFormat((PropertiedObject.Property)DebtorSalesItemReport.Properties.COGS).setName("COGS $"), new PropertyColumnFormat((PropertiedObject.Property)DebtorSalesItemReport.Properties.COGS_PERC).setName("COGS %").setFormatter((Format)new DecimalFormat("0.0%")));
        if (ExperimentalFeatureHelper.isShowItemIds()) {
            cols.add(4, (ColumnFormat)new PropertyColumnFormat((PropertiedObject.Property)DebtorSalesItemReport.Properties.UNIT_ID));
        }
        return cols.toArray(new ColumnFormat[cols.size()]);
    }

    public DebtorSalesItemReportSearcher getSearcher() {
        if (this.searcher == null) {
            this.searcher = new DebtorSalesItemReportSearcher();
        }
        return this.searcher;
    }
}

