/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.debtortransaction;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.Calendar;
import java.util.Collection;
import javax.swing.Action;
import officemate.adminkit.state.SearchGuiState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.reports.DebtorTransactionSummaryReport;
import ordermate.database.searchers.reports.DebtorTransactionSummaryReportSearcher;
import ordermate.database.users.Permission;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class DebtorTransactionSummaryReportSearchState
extends AbstractTableState<DebtorTransactionSummaryReport>
implements SearchGuiState<DebtorTransactionSummaryReport> {
    DebtorTransactionSummaryReportSearcher searcher = new DebtorTransactionSummaryReportSearcher();
    private static final EventList debtorGroupList = GlazedLists.eventList((Collection)DebtorGroup.getAllDebtorGroups());

    public DebtorTransactionSummaryReportSearchState(String stateName, Permission permission, String description) {
        super(stateName, permission, description);
    }

    @Override
    public ObjectQuerySearcher<DebtorTransactionSummaryReport> getSearcher() {
        return this.searcher;
    }

    @Override
    protected OfficeMateObjectSearch<DebtorTransactionSummaryReport> createSearchPanelFactory() {
        ObjectPropertySearch<DebtorTransactionSummaryReport> search = new ObjectPropertySearch<DebtorTransactionSummaryReport>(DebtorTransactionSummaryReport.class, this.getSearcher(), (EventList<DebtorTransactionSummaryReport>)new BasicEventList());
        search.useSearchRefreshStrategy();
        RefreshAction refreshAction = new RefreshAction(search);
        search.addSearchField((SearchGuiField)new DateRangeSearchField("Date Range", (IRangedQuerySearchFilter)this.searcher.getDebtorTransactionDateRangeSearch(), Calendar.getInstance().getTime(), (Action)refreshAction));
        search.addSearchField((SearchGuiField)new StringSearchField("Name Search", (ISingleValueSearchFilter)this.searcher.getDebtorNameSearchFilter(), (Action)refreshAction));
        MultiSelectComboSearchField debtorGroupField = new MultiSelectComboSearchField("Debtor Group", null, debtorGroupList, null, this.searcher.getDebtorGroupSearchFilter(), new JCheckBoxCellRenderer());
        search.addSearchField((SearchGuiField)debtorGroupField);
        return search;
    }

    @Override
    protected TableStateCentralArea<DebtorTransactionSummaryReport> createCentralArea() {
        PersistentObjectTable<DebtorTransactionSummaryReport> centralTable = new PersistentObjectTable<DebtorTransactionSummaryReport>(this.getObjectList(), new ColumnTableFormat((ColumnFormat[])new PropertyColumnFormat[]{new PropertyColumnFormat("Debtor Group", DebtorTransactionSummaryReport.Properties.DEBTOR_GROUP), new PropertyColumnFormat("Debtor Name", DebtorTransactionSummaryReport.Properties.DEBTOR_NAME), new PropertyColumnFormat("Balance", DebtorTransactionSummaryReport.Properties.BALANCE), new PropertyColumnFormat("Total Cost", DebtorTransactionSummaryReport.Properties.COST_TOTAL), new PropertyColumnFormat("Sales Exc. Tax", (PropertiedObject.Property)DebtorTransactionSummaryReport.Properties.SALES_EX_TAX), new PropertyColumnFormat("Tax Amount", DebtorTransactionSummaryReport.Properties.TAX), new PropertyColumnFormat("Sales Inc. Tax", DebtorTransactionSummaryReport.Properties.SALES_INC_TAX), new PropertyColumnFormat("Payments", DebtorTransactionSummaryReport.Properties.PAYMENTS)}));
        centralTable.groupOn("Debtor Group", "Balance", "Total Cost", "Sales Exc. Tax", "Tax Amount", "Sales Inc. Tax", "Payments");
        return centralTable;
    }

    @Override
    protected Class<DebtorTransactionSummaryReport> getDisplayingType() {
        return DebtorTransactionSummaryReport.class;
    }
}

