/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.driver;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.driver.DriverManifestReport;
import ordermate.database.searchers.reports.driver.DriverManifestReportSearcher;
import ordermate.database.users.Permission;
import ordermate.database.users.User;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class DriverManifestTableState
extends AbstractTableState<DriverManifestReport> {
    private DriverManifestReportSearcher searcher;
    private EventList<TradingDay> tradingDays;
    private EventList<User> driverList;

    public DriverManifestTableState(DriverManifestReportSearcher searcher, Permission permission) {
        super("Driver Manifest", permission, "The table of driver manifest reports");
        this.searcher = searcher;
        this.tradingDays = new BasicEventList();
        this.tradingDays.addAll((Collection)TradingDay.getAllTradingDays());
        Collections.reverse(this.tradingDays);
        this.driverList = new BasicEventList();
        this.driverList.addAll((Collection)User.getAllDrivers());
    }

    @Override
    protected OfficeMateObjectSearch<DriverManifestReport> createSearchPanelFactory() {
        ObjectPropertySearch<DriverManifestReport> search = new ObjectPropertySearch<DriverManifestReport>(DriverManifestReport.class, (ObjectQuerySearcher)this.searcher, (EventList)new BasicEventList()){

            @Override
            public void reaquireSearchOptions() {
                super.reaquireSearchOptions();
                ArrayList days = new ArrayList(TradingDay.getAllTradingDays());
                Collections.reverse(days);
                GlazedListUtils.setAsList((EventList)DriverManifestTableState.this.tradingDays, days);
                GlazedListUtils.setAsList((EventList)DriverManifestTableState.this.driverList, (Collection)User.getAllDrivers());
            }
        };
        RefreshAction refresh = new RefreshAction((Refreshable)search);
        search.addSearchField((SearchGuiField)new ComboSearchField("Trading Day", (ISingleValueSearchFilter)this.searcher.getTradingDayFilter(), false, (Action)refresh, this.tradingDays));
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Driver", (Action)refresh, this.driverList, null, this.searcher.getDriverFilter(), new JCheckBoxCellRenderer()));
        return search;
    }

    @Override
    protected TableStateCentralArea<DriverManifestReport> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat((PropertiedObject.Property)DriverManifestReport.Properties.DRIVER_NAME), new PropertyColumnFormat((PropertiedObject.Property)DriverManifestReport.Properties.DELIVERY_ID), new PropertyColumnFormat((PropertiedObject.Property)DriverManifestReport.Properties.DELIVERY_CREATED, (Format)DateTimeUtils.getConsistentReportFormat()), new PropertyColumnFormat((PropertiedObject.Property)DriverManifestReport.Properties.DELIVERY_COMPLETED, (Format)DateTimeUtils.getConsistentReportFormat()), new PropertyColumnFormat(DriverManifestReport.Properties.DUE_DATE_TIME, (Format)DateTimeUtils.getConsistentReportFormat()), new PropertyColumnFormat((PropertiedObject.Property)DriverManifestReport.Properties.CUSTOMER_NAME), new PropertyColumnFormat((PropertiedObject.Property)DriverManifestReport.Properties.CUSTOMER_ADDRESS), new PropertyColumnFormat((PropertiedObject.Property)DriverManifestReport.Properties.CUSTOMER_SUBURB), new PropertyColumnFormat((PropertiedObject.Property)DriverManifestReport.Properties.CUSTOMER_POSTCODE), new PropertyColumnFormat((PropertiedObject.Property)DriverManifestReport.Properties.RECEIPT_NUMBER), new PropertyColumnFormat("Items Total", (PropertiedObject.Property)DriverManifestReport.Properties.ITEMS_QUANTITY_TOTAL), new PropertyColumnFormat((PropertiedObject.Property)DriverManifestReport.Properties.ACCOUNT_TOTAL)});
        return new PersistentObjectTable<DriverManifestReport>(this.getObjectList(), format);
    }

    @Override
    protected Class<DriverManifestReport> getDisplayingType() {
        return DriverManifestReport.class;
    }
}

