/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.events;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.search.searchfield.EventTypeSelectionField;
import officemate.components.search.searchfield.TimeRangeSearchField;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.EventLogRecord;
import ordermate.database.misc.OfficeMateEventLog;
import ordermate.database.misc.ServermateEventLog;
import ordermate.database.misc.StockControlEventLog;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.searchers.reports.EventSearcher;
import ordermate.database.users.User;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class EventSearchState
extends ObjectPropertySearch<EventLogRecord> {
    private EventList<User> userList = new BasicEventList();
    private EventList<Terminal> terminalList = new BasicEventList();
    private EventList<Shift> shiftList = new BasicEventList();
    private EventSearcher searcher;
    private EventTypeSelectionField eventTypes;
    private static final String STATUS_MESSAGE = "Status: ";
    public final Signal<String, ?, ?, ?, ?> statusSignal = Signals.createSignal(String.class, (String)"status");

    public EventSearchState() {
        super(EventLogRecord.class);
        RefreshAction refresh = new RefreshAction((Refreshable)this);
        this.getSearcher();
        this.userList.addAll((Collection)User.getUsers());
        this.addSearchField((SearchGuiField)new DateRangeSearchField("", this.searcher.getDateRangeFilter(), null, (Action)refresh));
        this.addSearchField(new TimeRangeSearchField(this.searcher.getTimeRangeFilter(), (Action)refresh));
        this.addSearchField((SearchGuiField)new StringSearchField("Search:", this.searcher.getEventLogTextFilter(), (Action)refresh));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("User:", (Action)refresh, this.userList, null, this.searcher.getUserFilter(), new JCheckBoxCellRenderer()));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Terminal:", (Action)refresh, this.terminalList, null, this.searcher.getTerminalFilter(), new JCheckBoxCellRenderer()));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Shift:", (Action)refresh, this.shiftList, null, this.searcher.getShiftFilter(), new JCheckBoxCellRenderer()));
        this.eventTypes = new EventTypeSelectionField(this.searcher.getEventTypeFilter(), (Action)refresh, this.getTypes());
        this.customPanel.setLayout(new BorderLayout());
        this.customPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.addToSearchPanel((JComponent)this.eventTypes.getGuiComponent());
        this.addSearchField(this.eventTypes);
    }

    @Override
    public void reaquireSearchOptions() {
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.userList, User.getUsers());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.terminalList, Terminal.getAllTerminalsExceptServer());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.shiftList, Shift.getAllShiftsFor((Date)((Date)this.searcher.getDateRangeFilter().getStart()), (Date)((Date)this.searcher.getDateRangeFilter().getEnd())));
    }

    public ObjectQuery getBaseQuery() {
        return Query.select(EventLogRecord.class);
    }

    @Override
    public ObjectQuerySearcher<EventLogRecord> constructPropertySearcher() {
        return new EventSearcher();
    }

    @Override
    public void doRefresh() {
        this.statusSignal.emit((Object)"Status: Searching...");
        super.doRefresh();
        if (this.getObjectList().isEmpty()) {
            this.statusSignal.emit((Object)"Status: No results found!");
        } else {
            this.statusSignal.emit((Object)"Status: Completed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addSearchFields() {
        List list = this.searchFields;
        synchronized (list) {
            for (Object element : this.searchFields) {
                if (element == this.eventTypes) continue;
                SearchGuiField field = (SearchGuiField)element;
                this.addToSearchGui(this.searchGui, field);
            }
        }
    }

    @Override
    protected void addCustomFields() {
        if (!this.customComps.isEmpty()) {
            this.customPanel.setEnabled(true);
            for (JComponent custComp : this.customComps) {
                this.customPanel.add((Component)custComp, "South");
            }
        }
    }

    public EventSearcher getSearcher() {
        if (this.searcher == null) {
            this.searcher = (EventSearcher)super.getPropertySearcher();
        }
        return this.searcher;
    }

    private HashMap<String, List<String>> getTypes() {
        HashMap<String, List<String>> typesList = new HashMap<String, List<String>>();
        ArrayList<String> terminalTypes = new ArrayList<String>();
        terminalTypes.addAll(TerminalEventLog.getInst().getAllEvents());
        terminalTypes.add(0, "All WaiterMate Events".toUpperCase());
        typesList.put("WaiterMate", terminalTypes);
        ArrayList<String> stockTypes = new ArrayList<String>();
        stockTypes.addAll(StockControlEventLog.getInst().getAllEvents());
        stockTypes.add(0, "All Stock Control Events".toUpperCase());
        typesList.put("Stock", stockTypes);
        ArrayList<String> servermateTypes = new ArrayList<String>();
        servermateTypes.addAll(ServermateEventLog.getInst().getAllEvents());
        servermateTypes.add(0, "All ServerMate Events".toUpperCase());
        typesList.put("ServerMate", servermateTypes);
        ArrayList<String> officeMateTypes = new ArrayList<String>();
        officeMateTypes.addAll(OfficeMateEventLog.getInst().getAllEvents());
        officeMateTypes.add(0, "All OfficeMate Events".toUpperCase());
        typesList.put("OfficeMate", officeMateTypes);
        return typesList;
    }
}

