/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.events;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.util.DateDMY;
import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Time;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ordermate.database.misc.EventLogRecord;
import ordermate.gui.FieldPanelBuilder;

public class EventViewPanel
implements ObjectEditor<EventLogRecord> {
    private EventLogRecord eventLogRecord;
    private JLabel user;
    private JLabel terminal;
    private JLabel type;
    private JLabel timeStamp;
    private JTextArea message;
    private FieldPanelBuilder builder;
    private JPanel mainPanel = new JPanel();

    public EventViewPanel() {
        this.mainPanel.setLayout(new BorderLayout());
        this.builder = new FieldPanelBuilder();
        this.user = this.addTextField("User: ");
        this.terminal = this.addTextField("Terminal: ");
        this.type = this.addTextField("Type: ");
        this.timeStamp = this.addTextField("Timestamp: ");
        this.message = this.createTextAreaField();
        this.mainPanel.add((Component)this.builder.getPanel(), "North");
        JScrollPane scrollPane = new JScrollPane(this.message);
        this.mainPanel.add((Component)scrollPane, "Center");
    }

    protected JLabel addTextField(String title) {
        JLabel label = new JLabel();
        this.builder.addRow(title, (Component)label);
        return label;
    }

    protected JTextArea createTextAreaField() {
        JTextArea area = new JTextArea(5, 80);
        area.setEditable(false);
        return area;
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public EventLogRecord getObject() {
        return this.eventLogRecord;
    }

    public void setObject(EventLogRecord toView) {
        this.eventLogRecord = toView;
        if (this.eventLogRecord.getUser() != null) {
            this.user.setText(this.eventLogRecord.getUser().toString());
        } else {
            this.user.setText("");
        }
        if (this.eventLogRecord.getTerminal() != null) {
            this.terminal.setText(this.eventLogRecord.getTerminal().toString());
        } else {
            this.terminal.setText("");
        }
        this.type.setText(this.eventLogRecord.getType());
        if (this.eventLogRecord.getEventDate() != null) {
            DateDMY date = new DateDMY(this.eventLogRecord.getEventDate());
            this.timeStamp.setText(date.toString());
        } else {
            this.timeStamp.setText("");
        }
        if (this.eventLogRecord.getEventTime() != null) {
            Time time = Time.valueOf(this.eventLogRecord.getEventTime().toString());
            this.timeStamp.setText(time.toString());
        } else {
            this.timeStamp.setText("");
        }
        this.message.setText(this.eventLogRecord.getMessage());
    }

    public final boolean isGuiValid() {
        return true;
    }

    public final void saveObject() {
    }

    public void revertObject() {
    }
}

