/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.events;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.PermissibleAction;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.pager.Pager;
import au.com.ordermate.search.pager.PagerModel;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.Format;
import java.util.Date;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.state.login.LoginState;
import officemate.components.EditorDialog;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.reports.events.EventSearchState;
import officemate.screens.reports.events.EventViewPanel;
import ordermate.database.misc.EventLogRecord;
import ordermate.database.searchers.reports.EventSearcher;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.Permission;
import ordermate.integration.camera.CameraViewer;
import ordermate.integration.camera.CameraViewerFactory;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import ordermate.signals.Signal;

public class EventsState
extends AbstractTableState<EventLogRecord> {
    private static ObjectEditor<EventLogRecord> editor = null;
    private static EditorDialog editorDialog = null;
    private final PagerModel listPager = new PagerModel();
    private ColumnTableFormat cols;
    private JLabel statusPanel = new JLabel("Status: Completed");

    public EventsState(Permission permission) {
        super("Transaction Journal", permission, "View transaction journal entries");
        this.addAction((Action)((Object)new ClearAction()));
        this.addSelectionDependentAction((Action)((Object)new ShowCameraEventAction()));
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        if (editor == null) {
            editor = new EventViewPanel();
        }
        if (editorDialog == null) {
            editorDialog = new EditorDialog("", editor, "View Transaction Entries", "To close this window, press Ok or Cancel.");
        }
        this.addPageControl(this.listPager);
        this.statusPanel.setOpaque(true);
        this.statusPanel.setBackground(new Color(240, 240, 240));
        this.addStatusComponent(this.statusPanel, "East");
    }

    @Override
    protected void onStart() {
        super.onStart();
        Signal<String, ?, ?, ?, ?> signal = ((EventSearchState)this.getSearchFactory()).statusSignal;
        if (!signal.isConnected()) {
            signal.connect((Object)this, "updateStatus");
        }
    }

    @Override
    protected void onEnd() {
        ((EventSearchState)this.getSearchFactory()).statusSignal.disconnect((Object)this);
        super.onEnd();
    }

    @Override
    public TableStateCentralArea<EventLogRecord> createCentralArea() {
        this.createColumnFormat();
        PersistentObjectTable<EventLogRecord> centralArea = new PersistentObjectTable<EventLogRecord>(this.getObjectList(), this.cols);
        JPanel searchBar = this.getSearchFactory().getSearchPanel();
        centralArea.add((Component)searchBar, "North");
        centralArea.getTable().getColumnExt((Object)EventLogRecord.Properties.SHIFT).setVisible(false);
        return centralArea;
    }

    public ColumnTableFormat getColumnFormat() {
        if (this.cols == null) {
            this.createColumnFormat();
        }
        return this.cols;
    }

    private void createColumnFormat() {
        this.cols = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(EventLogRecord.Properties.EVENT_DATE).setFormatter((Format)DateTimeUtils.getSQLDateFormat()), new PropertyColumnFormat(EventLogRecord.Properties.EVENT_TIME).setFormatter((Format)DateTimeUtils.getSQLTimeFormat()), new PropertyColumnFormat(EventLogRecord.Properties.TYPE), new PropertyColumnFormat(EventLogRecord.Properties.USER), new PropertyColumnFormat(EventLogRecord.Properties.TERMINAL), new PropertyColumnFormat(EventLogRecord.Properties.MESSAGE), new PropertyColumnFormat(EventLogRecord.Properties.SHIFT)});
    }

    @Override
    public Class<EventLogRecord> getDisplayingType() {
        return EventLogRecord.class;
    }

    @Override
    public OfficeMateObjectSearch<EventLogRecord> createSearchPanelFactory() {
        EventSearchState searchState = new EventSearchState();
        searchState.usePagedObjectQueryRefreshStrategy((Pager)this.listPager);
        return searchState;
    }

    @Override
    public void gotObjectDoubleClicked(EventLogRecord toEdit) {
        EventLogRecord selected = (EventLogRecord)this.getCentralArea().getSelectedObject();
        if (selected != null) {
            editor.setObject((Object)selected);
            editorDialog.doModal();
        }
    }

    public void updateStatus(String newText) {
        this.statusPanel.setText(newText);
    }

    public EventSearcher getSearcher() {
        return ((EventSearchState)this.getSearchFactory()).getSearcher();
    }

    private class ClearAction
    extends PermissibleAction {
        public ClearAction() {
            super("Clear Log", AllPermissions.CLEAR_EVENT_LOG, LoginState.getInstance().login, (Icon)IconLoader.get((String)"/ordermate/images/deleteall_icon22.png"), "Clear the Transaction Log", EventsState.this.getUser());
        }

        public void actionPerformed(ActionEvent e) {
            String message = "Clearing the Transaction Log is permanent and cannot be undone.\nOnce the Transaction Log has been cleared the records can no longer be read.";
            JOptionPane pane = new JOptionPane(message, 2, 2);
            JDialog dialog = pane.createDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Clear Transaction Entries?");
            dialog.setVisible(true);
            Object result = pane.getValue();
            if (result instanceof Integer && (Integer)result == 0) {
                String query = "TRUNCATE system_log";
                PersistenceManager.getPersistenceDelegate().executeUpdate(query, new Object[0]);
            }
            EventsState.this.refresh();
        }
    }

    private class ShowCameraEventAction
    extends PermissibleAction {
        public ShowCameraEventAction() {
            super("View Camera", AllPermissions.VIEW_TRANSACTION_JOURNAL, LoginState.getInstance().login, (Icon)IconLoader.get((String)"/officemate/images/cctv-camera-icon.png"), "View Event from the camera integration.", EventsState.this.getUser());
        }

        public void actionPerformed(ActionEvent e) {
            CameraViewer call = CameraViewerFactory.getCameraCall();
            if (call != null) {
                EventLogRecord record = (EventLogRecord)EventsState.this.getCentralArea().getSelectedObject();
                if (record != null) {
                    call.showFootage(record == null ? new Date() : record.getEventDate(), record.getTerminal());
                }
            } else {
                Dialogs.showWarningDialog("No Camera", "There is no supported camera integration configured.");
            }
        }
    }
}

