/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.futureorder;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.SingleValueQuerySearchFilter;
import au.com.ordermate.search.control.DateRangePanel;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.text.Format;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import officemate.adminkit.state.SearchGuiState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.search.objectsearch.CustomerSearcherGui;
import officemate.components.search.searchfield.ObjectSearchField;
import officemate.components.search.searchfield.TimeRangeSearchField;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.Shift;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.OnlineAccount;
import ordermate.database.sales.OnlineAccountHelper;
import ordermate.database.searchers.sales.AccountSearcher;
import ordermate.database.users.AllPermissions;
import ordermate.gui.binding.ColumnVisibilityHelper;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class FutureOrderTableState
extends AbstractTableState<Account>
implements SearchGuiState<Account> {
    private AccountSearcher searcher;
    private EventList<AccountType> accTypeList;
    private EventList<String> orderSourceList;

    public FutureOrderTableState() {
        super("Search", AllPermissions.ACCESS_SALES_REPORT, "View all Accounts that were ordered days beforehand");
    }

    @Override
    protected OfficeMateObjectSearch<Account> createSearchPanelFactory() {
        AccountSearcher localSearcher = (AccountSearcher)this.getSearcher();
        localSearcher.setAccountOpen(true);
        ObjectPropertySearch<Account> search = new ObjectPropertySearch<Account>(Account.class, (ObjectQuerySearcher<Account>)localSearcher, (EventList<Account>)new BasicEventList());
        RefreshAction refresh = new RefreshAction(search);
        DateRangePanel dateRangePanel = new DateRangePanel(Calendar.getInstance(), Calendar.getInstance(), "Start Due Date:", "End Due Date:");
        search.addSearchField((SearchGuiField)new DateRangeSearchField("Due Date Range", (IRangedQuerySearchFilter)this.searcher.getDateDueRangeSearch(), new Date(), (Action)refresh, dateRangePanel));
        search.addSearchField(new TimeRangeSearchField("Time Due Range", this.searcher.getTimeDueSearch(), (Action)refresh, false));
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Shift", (MultiOptionSearchFilter)this.searcher.getShiftNameSearch(), (Action)refresh, GlazedLists.eventListOf((Object[])Shift.getShiftNames())));
        search.addSearchField(new ObjectSearchField((SingleValueQuerySearchFilter)localSearcher.getCustomerSearch(), (OfficeMateObjectSearch)new CustomerSearcherGui(GlazedLists.eventList((Collection)CustomerCategory.getAllCategories())), CustomerSearcherGui.DEFAULT_TABLE_FORMAT, "Customer", (Action)refresh));
        this.accTypeList = GlazedLists.eventListOf((Object[])AccountType.getTypes());
        MultiSelectComboSearchField accountTypeComboField = new MultiSelectComboSearchField("Account Type:", null, this.accTypeList, null, this.searcher.getAccountTypeListSearch(), new JCheckBoxCellRenderer());
        accountTypeComboField.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof AccountType) {
                    AccountType type = (AccountType)value;
                    this.setText(type.getLabel());
                }
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                return this;
            }
        });
        search.addSearchField((SearchGuiField)accountTypeComboField);
        this.orderSourceList = GlazedLists.eventList((Collection)OnlineAccountHelper.getOnlineAccountOrderSources());
        MultiSelectComboSearchField orderSourceComboField = new MultiSelectComboSearchField("Order Source:", (Action)refresh, this.orderSourceList, null, this.searcher.getOrderSourceListSearch(), new JCheckBoxCellRenderer());
        search.addSearchField((SearchGuiField)orderSourceComboField);
        MultiSelectComboSearchField salesLocationField = new MultiSelectComboSearchField("Sales Location:", (Action)refresh, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations()), null, this.searcher.getSalesLocationFilter(), new JCheckBoxCellRenderer());
        search.addSearchField((SearchGuiField)salesLocationField);
        return search;
    }

    @Override
    protected TableStateCentralArea<Account> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(Account.Properties.DATE_DUE), new PropertyColumnFormat(Account.Properties.TIME_DUE, (Format)DateTimeUtils.getSimpleTimeFormat()), new PropertyColumnFormat(Account.Properties.CUSTOMER), new PropertyColumnFormat(Account.Properties.PREP_PRINT_DUE), new PropertyColumnFormat(Account.Properties.ACCOUNT_STATE), new PropertyColumnFormat(Account.Properties.ACCOUNT_TYPE), new AbstractColumnFormat("Order Source", String.class){

            public Object resolveColumnValue(Object baseObject) {
                Account account = (Account)baseObject;
                if (account instanceof OnlineAccount) {
                    return ((OnlineAccount)account).getSource();
                }
                return "";
            }
        }});
        PersistentObjectTable<Account> table = new PersistentObjectTable<Account>(this.getObjectList(), format);
        return table;
    }

    @Override
    protected JPanel getControlPanel() {
        JPanel panel = super.getControlPanel();
        ColumnVisibilityHelper showOrderSource = new ColumnVisibilityHelper((Object[])new String[]{"Order Source"}, new JCheckBox("Show Order Source"), this.getCentralArea().getTable());
        JPanel helperPanel = new JPanel(new FlowLayout(2));
        helperPanel.add(showOrderSource.getCheckBox());
        JPanel panelTest = new JPanel(new BorderLayout());
        panelTest.add((Component)panel, "Center");
        panelTest.add((Component)helperPanel, "South");
        return panelTest;
    }

    @Override
    protected Class<Account> getDisplayingType() {
        return Account.class;
    }

    @Override
    public ObjectQuerySearcher<Account> getSearcher() {
        if (this.searcher == null) {
            this.searcher = new AccountSearcher();
        }
        return this.searcher;
    }
}

