/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.hourlysales;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.util.Price;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.PropertyArrayColumnFormat;
import officemate.screens.reports.hourlysales.HourlySalesReportSearchControl;
import ordermate.database.reports.hourlysales.HourlySalesCollation;
import ordermate.database.reports.hourlysales.HourlySalesCompiler;
import ordermate.database.reports.hourlysales.HourlySalesTableData;
import ordermate.database.reports.hourlysales.HourlySalesValueType;
import ordermate.database.searchers.reports.hourlysales.HourlySalesReportSearcher;
import ordermate.database.users.Permission;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.swingx.JXTable;

public class HourlySalesReportTableState
extends AbstractTableState<HourlySalesCollation>
implements ActionListener {
    private HourlySalesTableData data;
    boolean initCalled = false;
    private JComboBox valueTypeCombo;
    private JCheckBox hideZeroColumns;
    private ColumnTableFormat tableFormat;

    HourlySalesReportTableState(HourlySalesTableData data, Permission permission) {
        super("Sales By Hour By " + data.getColumnLabel(), permission, "View sales and volume broken down by hour.");
        this.data = data;
    }

    @Override
    protected OfficeMateObjectSearch<HourlySalesCollation> createSearchPanelFactory() {
        HourlySalesReportSearchControl control = new HourlySalesReportSearchControl(new HourlySalesCompiler(this.data), new RefreshAction((Refreshable)this));
        JPanel panel = control.getSearchPanel();
        JPanel controlHolder = new JPanel(new GridLayout(3, 2));
        this.valueTypeCombo = new JComboBox<HourlySalesValueType>(HourlySalesValueType.values());
        this.valueTypeCombo.addActionListener(this);
        controlHolder.add(new JLabel("Value Type"));
        controlHolder.add(this.valueTypeCombo);
        ComponentUtils.setupComboBox((JComboBox)this.valueTypeCombo);
        this.hideZeroColumns = new JCheckBox();
        this.hideZeroColumns.addActionListener(this);
        controlHolder.add(new JLabel("Hide Zero Columns"));
        controlHolder.add(this.hideZeroColumns);
        panel.add((Component)controlHolder, "East");
        return control;
    }

    @Override
    protected TableStateCentralArea<HourlySalesCollation> createCentralArea() {
        this.tableFormat = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(this.data.getColumnLabel(), HourlySalesCollation.Properties.LABEL), new PropertyColumnFormat("Total Sales", HourlySalesCollation.Properties.SALES_TOTAL), new PropertyColumnFormat("Total Qty", HourlySalesCollation.Properties.QTY_TOTAL)});
        HashSet<PropertyArrayColumnFormat> qtys = new HashSet<PropertyArrayColumnFormat>();
        HashSet<PropertyArrayColumnFormat> sales = new HashSet<PropertyArrayColumnFormat>();
        this.data.init();
        for (int i = 0; i < 24; ++i) {
            StringBuilder SB = new StringBuilder("<html>");
            SB.append(i).append(":00-<br> ").append(i + 1).append(":00</html>");
            PropertyArrayColumnFormat colFormat = new PropertyArrayColumnFormat(HourlySalesCollation.Properties.SALES_DATA, i, SB.toString(), Price.class);
            sales.add(colFormat);
            this.tableFormat.addColumn((ColumnFormat)colFormat);
            colFormat = new PropertyArrayColumnFormat(HourlySalesCollation.Properties.QTY_DATA, i, SB.toString(), BigDecimal.class, NumberFormat.getNumberInstance());
            qtys.add(colFormat);
            this.tableFormat.addColumn((ColumnFormat)colFormat);
        }
        PersistentObjectTable<HourlySalesCollation> table = new PersistentObjectTable<HourlySalesCollation>(this.getObjectList(), this.tableFormat);
        JXTable jxTable = table.getTable();
        jxTable.setColumnControlVisible(false);
        return table;
    }

    @Override
    protected void postRefresh() {
        super.postRefresh();
        this.changeValueType(this.data.getValueType());
    }

    @Override
    protected Class<HourlySalesCollation> getDisplayingType() {
        return HourlySalesCollation.class;
    }

    private void changeValueType(HourlySalesValueType type) {
        if (type != null) {
            this.data.setValueType(type);
        }
        this.data.setHideZeroes(this.hideZeroColumns.isSelected());
        this.data.updateColumnVisibility();
        JXTable jxTable = this.getCentralArea().getTable();
        Map visible = this.data.getColumnVisibility();
        for (Map.Entry entry : visible.entrySet()) {
            jxTable.getColumnExt(entry.getKey()).setVisible(((Boolean)entry.getValue()).booleanValue());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.valueTypeCombo) {
            this.changeValueType((HourlySalesValueType)this.valueTypeCombo.getSelectedItem());
        } else if (source == this.hideZeroColumns) {
            this.data.setHideZeroes(this.hideZeroColumns.isSelected());
        }
    }

    @Override
    public void onEnd() {
        this.getSearchFactory().stopRefresh();
    }

    HourlySalesReportSearcher getSearcher() {
        return this.data.getSearcher();
    }

    HourlySalesValueType getValueType() {
        return this.data.getValueType();
    }

    String getColumnLabel() {
        return this.data.getColumnLabel();
    }
}

