/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.itemgp;

import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.sql.ResultSet;
import java.sql.SQLException;
import officemate.adminkit.table.QueryTableModel;
import ordermate.database.DBConnectionInterface;

class ItemGPTableModel
extends QueryTableModel {
    public ItemGPTableModel(SelectQuery selQuery, DBConnectionInterface dc, String idField, String[] colNames, String[] colDisplayNames) {
        super(selQuery, dc, idField, colNames, colDisplayNames);
    }

    @Override
    protected Object getTableValue(int row, int col, String colName, int dbColIndex, ResultSet rs) throws SQLException {
        if (colName.equals("Cost")) {
            return new Price(rs.getDouble(colName), 0.01);
        }
        if (colName.equals("inventory_unit_price_level_link.Price")) {
            return new Price(rs.getDouble(colName), 0.01);
        }
        if (colName.equals("GPPercent")) {
            Price grossProfit = new Price((Number)FinanceUtils.getGrossProfit((long)rs.getLong("inventory_item_unit.ID"), (double)rs.getDouble("inventory_unit_price_level_link.Price"), (double)rs.getDouble("CostEx")), 0.0);
            Price totalSales = new Price(rs.getDouble("inventory_unit_price_level_link.Price"), 0.0);
            if (!grossProfit.isZero() && !totalSales.isZero()) {
                double gPPercent = grossProfit.doubleValue() / (totalSales.doubleValue() - FinanceUtils.getUnitSalesTax((long)rs.getLong("inventory_item_unit.ID"), (double)rs.getDouble("inventory_unit_price_level_link.Price")).doubleValue()) * 100.0;
                return new Double(MathsUtils.roundDoubleToDecPlaces((double)gPPercent, (int)1));
            }
            return 0.0;
        }
        if (colName.equals("GPValue")) {
            return new Price(FinanceUtils.getGrossProfit((long)rs.getLong("inventory_item_unit.ID"), (double)rs.getDouble("inventory_unit_price_level_link.Price"), (double)rs.getDouble("CostEx")).doubleValue(), 0.01);
        }
        if (colName.equals("CostEx")) {
            return new Price(rs.getDouble(colName), 0.01);
        }
        return super.getTableValue(row, col, colName, dbColIndex, rs);
    }

    @Override
    protected Number getTotalValue(int column, double rawValue, String colName, int dbColIndex) {
        if (colName.equals("Cost") || colName.equals("inventory_unit_price_level_link.Price") || colName.equals("GPValue") || colName.equals("CostEx")) {
            return new Price(rawValue, 0.01);
        }
        if (colName.equals("GPPercent")) {
            double sales = this.getTotal("inventory_unit_price_level_link.Price").doubleValue();
            double cost = this.getTotal("Cost").doubleValue();
            if (sales == 0.0) {
                return Double.NaN;
            }
            double percent = 100.0 * (sales - cost) / sales;
            return new Double(MathsUtils.roundDoubleToDecPlaces((double)percent, (int)1));
        }
        return super.getTotalValue(column, rawValue, colName, dbColIndex);
    }
}

