/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.itemssold.substates.adhocreport;

import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.AbstractSearcher;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageResizeHelper;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import officemate.adminkit.state.SearchGuiState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ItemPropertySearch;
import officemate.components.search.searchfield.TimeRangeSearchField;
import officemate.components.search.translator.DefaultSearcherTranslator;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.reports.CSVExportAction;
import officemate.screens.reports.itemssold.substates.adhocreport.ClearCacheAction;
import ordermate.OrderMate;
import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.misc.SystemProperty;
import ordermate.database.reports.sales.general.itemsold.ItemSoldReport;
import ordermate.database.searchers.reports.sales.general.itemsold.ItemSoldReportCompiler;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.Permission;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.ColumnVisibilityHelper;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.swingx.JXTable;

public class ItemSoldReportSearchState
extends AbstractTableState<ItemSoldReport>
implements SearchGuiState<ItemSoldReport> {
    private final EventList<ItemSoldReport> tableData = new BasicEventList();
    private ClearCacheAction clearAction;
    private final ItemSoldReportCompiler compiler;
    private DefaultSearcherTranslator simpleSearchQuery;
    JCheckBox groupByItemPriceCheckBox;
    private JCheckBox showCOGSCheckBox;

    public ItemSoldReportSearchState(ItemSoldReportCompiler reportCompiler, String stateName, Permission permission, String description) {
        super(stateName, permission, description);
        this.compiler = reportCompiler;
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        ColumnVisibilityHelper helper = new ColumnVisibilityHelper((Object[])new PropertiedObject.Property[]{ItemSoldReport.Properties.TOTAL_COGS, ItemSoldReport.Properties.TOTAL_COGS_PERCENTAGE}, this.showCOGSCheckBox, this.getTable());
    }

    @Override
    protected TableStateCentralArea<ItemSoldReport> createCentralArea() {
        PersistentObjectTable<ItemSoldReport> centralTable = new PersistentObjectTable<ItemSoldReport>(this.tableData, this.getTableFormat());
        centralTable.add((Component)this.getSearcherTranslator().getGuiComponent(), "South");
        this.addAction(this.getExportAction());
        return centralTable;
    }

    @Override
    protected Class<ItemSoldReport> getDisplayingType() {
        return ItemSoldReport.class;
    }

    @Override
    protected OfficeMateObjectSearch<ItemSoldReport> createSearchPanelFactory() {
        ItemPropertySearch<ItemSoldReport> guiSearch = new ItemPropertySearch<ItemSoldReport>(ItemSoldReport.class, this.tableData){

            @Override
            public ObjectQuerySearcher<ItemSoldReport> constructPropertySearcher() {
                return ItemSoldReportSearchState.this.compiler.getSearcher();
            }
        };
        guiSearch.useSearchRefreshStrategy();
        guiSearch.addSearchField((SearchGuiField)new DateRangeSearchField("Date", this.compiler.getSearcher().getTradingDayDateRangeFilter(), DateTimeUtils.getOneMonthAgoCal().getTime(), this.getRefreshAction()));
        FieldPanelBuilder builder = new FieldPanelBuilder();
        guiSearch.addSearchField(new TimeRangeSearchField(this.compiler.getSearcher().getSalesTimeRangeFilter(), this.getRefreshAction()));
        JPanel additionalFields = new JPanel();
        additionalFields.setLayout(new BoxLayout(additionalFields, 1));
        this.groupByItemPriceCheckBox = new JCheckBox(this.getRefreshAction());
        this.groupByItemPriceCheckBox.setText("");
        this.groupByItemPriceCheckBox.setName("groupByItemPriceCheckBox");
        builder.addRow("Group By Item Price", (Component)this.groupByItemPriceCheckBox);
        this.showCOGSCheckBox = new JCheckBox(this.getRefreshAction());
        this.showCOGSCheckBox.setText("");
        this.showCOGSCheckBox.setName("showCOGSCheckBox");
        builder.addRow("Show COGS", (Component)this.showCOGSCheckBox);
        additionalFields.add(builder.getPanel());
        additionalFields.add(guiSearch.itemSoldSearchSetup(this.compiler.getSearcher(), this.getRefreshAction()));
        guiSearch.addToSearchPanel(additionalFields);
        return guiSearch;
    }

    public boolean getShowCOGS() {
        return this.showCOGSCheckBox.isSelected();
    }

    @Override
    public ObjectQuerySearcher<ItemSoldReport> getSearcher() {
        return this.compiler.getSearcher();
    }

    private DefaultSearcherTranslator getSearcherTranslator() {
        if (this.simpleSearchQuery == null) {
            this.simpleSearchQuery = new DefaultSearcherTranslator();
        }
        return this.simpleSearchQuery;
    }

    public final ColumnTableFormat getTableFormat() {
        return new ColumnTableFormat(this.getColumnFormat());
    }

    private final ColumnFormat[] getColumnFormat() {
        ArrayList<Object> columnFormats = new ArrayList<Object>();
        columnFormats.addAll(Arrays.asList(new PropertyColumnFormat("Menu Section", (PropertiedObject.Property)ItemSoldReport.Properties.MENU_SECTION), new PropertyColumnFormat("Menu Item", ItemSoldReport.Properties.INVENTORY_ITEM_NAME), new PropertyColumnFormat(ItemSoldReport.Properties.INVENTORY_SIZE_NAME), new PropertyColumnFormat(ItemSoldReport.Properties.INVENTORY_PORTION_NAME), new PropertyColumnFormat("Category", ItemSoldReport.Properties.INVENTORY_CATEGORY), new PropertyColumnFormat("Redeemed", ItemSoldReport.Properties.LOYALTY_REDEEMED), new PropertyColumnFormat("Unit Price", (PropertiedObject.Property)ItemSoldReport.Properties.UNIT_PRICE), new PropertyColumnFormat("Quantity Sold", ItemSoldReport.Properties.QUANTITY_SOLD), new PropertyColumnFormat("Sales", (PropertiedObject.Property)ItemSoldReport.Properties.SALES_VALUE_RAW).setCustomRenderer((TableCellRenderer)new PriceCellRenderer())));
        columnFormats.addAll(Arrays.asList(new PropertyColumnFormat("COGS", ItemSoldReport.Properties.TOTAL_COGS), new PropertyColumnFormat("COGS %", (PropertiedObject.Property)ItemSoldReport.Properties.TOTAL_COGS_PERCENTAGE).setFormatter((Format)new DecimalFormat("0.0%"))));
        if ("1".equals(ReportProperty.find((ReportGroup)ReportGroup.ItemSold, (String)"Include Business Location").getValue())) {
            columnFormats.add(new PropertyColumnFormat("Business Location", (PropertiedObject.Property)ItemSoldReport.Properties.BUSINESS_LOCATION));
        }
        return columnFormats.toArray(new ColumnFormat[0]);
    }

    @Override
    public void refresh() {
        if (this.groupByItemPriceCheckBox != null) {
            this.compiler.getSearcher().setGroupItemsByPrice(this.groupByItemPriceCheckBox.isSelected());
        }
        super.refresh();
    }

    @Override
    public void onStart() {
        super.onStart();
        this.prepareClearCacheAction();
        this.showCOGSCheckBox.setSelected(SystemProperty.getInstance().isStockControlEnabled());
    }

    @Override
    protected void postRefresh() {
        super.postRefresh();
        this.getSearcherTranslator().updateTranslation((AbstractSearcher<? extends PersistentObjectI>)this.compiler.getSearcher());
    }

    public final JXTable getTable() {
        return this.getCentralArea().getTable();
    }

    @Override
    public EventList<ItemSoldReport> getObjectList() {
        return super.getObjectList();
    }

    private Action getExportAction() {
        return new CSVExportAction<ItemSoldReport>(this.getObjectList(), this.getColumnFormat(), "itemSold.csv");
    }

    public ItemSoldReportCompiler getCompiler() {
        return this.compiler;
    }

    private void prepareClearCacheAction() {
        if (this.getUser().hasPermission(AllPermissions.GOD_ONLY)) {
            if (this.clearAction == null) {
                this.clearAction = new ClearCacheAction("Clear Cache", new ImageResizeHelper().rescaleImageIcon(IconLoader.get((String)"/officemate/images/bomb.png"), 0.5));
                this.clearAction.setPermission(AllPermissions.GOD_ONLY);
            }
            if (!this.getDefaultActions().contains((Object)this.clearAction)) {
                this.addAction((Action)((Object)this.clearAction));
            }
        } else if (this.clearAction != null) {
            this.removeStateSpecificAction((Action)((Object)this.clearAction));
        }
    }

    static class PriceCellRenderer
    extends DefaultTableCellRenderer {
        PriceCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object localValue = value;
            try {
                localValue = Price.parsePrice((String)value.toString());
            }
            catch (NumberFormatException ex) {
                OrderMate.LOG.warn("Could not parse price " + value, (Throwable)ex);
            }
            return super.getTableCellRendererComponent(table, localValue, isSelected, hasFocus, row, column);
        }
    }
}

