/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.itemsunsold;

import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.AbstractSearcher;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageResizeHelper;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import officemate.adminkit.state.SearchGuiState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ItemPropertySearch;
import officemate.components.search.searchfield.TimeRangeSearchField;
import officemate.components.search.translator.DefaultSearcherTranslator;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.reports.CSVExportAction;
import officemate.screens.reports.itemsunsold.ClearCacheAction;
import ordermate.OrderMate;
import ordermate.database.reports.sales.general.itemunsold.ItemUnsoldReport;
import ordermate.database.searchers.reports.sales.general.itemunsold.ItemUnsoldReportCompiler;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.Permission;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.ColumnVisibilityHelper;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.swingx.JXTable;

public class ItemUnsoldReportSearchState
extends AbstractTableState<ItemUnsoldReport>
implements SearchGuiState<ItemUnsoldReport> {
    private final EventList<ItemUnsoldReport> tableData = new BasicEventList();
    private ClearCacheAction clearAction;
    private final ItemUnsoldReportCompiler compiler;
    private DefaultSearcherTranslator simpleSearchQuery;
    private JCheckBox showGPCheckBox;

    public ItemUnsoldReportSearchState(ItemUnsoldReportCompiler reportCompiler, String stateName, Permission permission, String description) {
        super(stateName, permission, description);
        this.compiler = reportCompiler;
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        ColumnVisibilityHelper helper = new ColumnVisibilityHelper((Object[])new PropertiedObject.Property[]{ItemUnsoldReport.Properties.GP_PERCENT, ItemUnsoldReport.Properties.GP_VALUE}, this.showGPCheckBox, this.getTable());
    }

    @Override
    protected TableStateCentralArea<ItemUnsoldReport> createCentralArea() {
        PersistentObjectTable<ItemUnsoldReport> centralTable = new PersistentObjectTable<ItemUnsoldReport>(this.tableData, this.getTableFormat());
        centralTable.add((Component)this.getSearcherTranslator().getGuiComponent(), "South");
        this.addAction(this.getExportAction());
        return centralTable;
    }

    @Override
    protected Class<ItemUnsoldReport> getDisplayingType() {
        return ItemUnsoldReport.class;
    }

    @Override
    protected OfficeMateObjectSearch<ItemUnsoldReport> createSearchPanelFactory() {
        ItemPropertySearch<ItemUnsoldReport> guiSearch = new ItemPropertySearch<ItemUnsoldReport>(ItemUnsoldReport.class, this.tableData){

            @Override
            public ObjectQuerySearcher<ItemUnsoldReport> constructPropertySearcher() {
                return ItemUnsoldReportSearchState.this.compiler.getSearcher();
            }
        };
        guiSearch.useSearchRefreshStrategy();
        guiSearch.addSearchField((SearchGuiField)new DateRangeSearchField("Date", this.compiler.getSearcher().getTradingDayDateRangeFilter(), DateTimeUtils.getOneMonthAgoCal().getTime(), this.getRefreshAction()));
        FieldPanelBuilder builder = new FieldPanelBuilder();
        guiSearch.addSearchField(new TimeRangeSearchField(this.compiler.getSearcher().getSalesTimeRangeFilter(), this.getRefreshAction()));
        JPanel additionalFields = new JPanel();
        additionalFields.setLayout(new BoxLayout(additionalFields, 1));
        this.showGPCheckBox = new JCheckBox(this.getRefreshAction());
        this.showGPCheckBox.setText("");
        this.showGPCheckBox.setName("showGPCheckBox");
        builder.addRow("Show GP", (Component)this.showGPCheckBox);
        additionalFields.add(builder.getPanel());
        additionalFields.add(guiSearch.itemUnSoldSearchSetup(this.compiler.getSearcher(), this.getRefreshAction()));
        guiSearch.addToSearchPanel(additionalFields);
        return guiSearch;
    }

    @Override
    public ObjectQuerySearcher<ItemUnsoldReport> getSearcher() {
        return this.compiler.getSearcher();
    }

    private DefaultSearcherTranslator getSearcherTranslator() {
        if (this.simpleSearchQuery == null) {
            this.simpleSearchQuery = new DefaultSearcherTranslator();
        }
        return this.simpleSearchQuery;
    }

    public final ColumnTableFormat getTableFormat() {
        return new ColumnTableFormat(this.getColumnFormat());
    }

    private final ColumnFormat[] getColumnFormat() {
        ArrayList<AbstractColumnFormat> columnFormats = new ArrayList<AbstractColumnFormat>();
        columnFormats.addAll(Arrays.asList(new PropertyColumnFormat("Menu Section", (PropertiedObject.Property)ItemUnsoldReport.Properties.MENU_SECTION), new PropertyColumnFormat("Menu Item", ItemUnsoldReport.Properties.INVENTORY_ITEM_NAME), new PropertyColumnFormat(ItemUnsoldReport.Properties.INVENTORY_SIZE_NAME), new PropertyColumnFormat(ItemUnsoldReport.Properties.INVENTORY_PORTION_NAME), new PropertyColumnFormat("Category", ItemUnsoldReport.Properties.INVENTORY_CATEGORY), new PropertyColumnFormat("Quantity Sold", ItemUnsoldReport.Properties.QUANTITY_SOLD), new PropertyColumnFormat("Item Price", ItemUnsoldReport.Properties.ITEM_PRICE), new PropertyColumnFormat("GP", ItemUnsoldReport.Properties.GP_VALUE), new PropertyColumnFormat("GP %", (PropertiedObject.Property)ItemUnsoldReport.Properties.GP_PERCENT).setFormatter((Format)new DecimalFormat("0.0%"))));
        return columnFormats.toArray(new ColumnFormat[0]);
    }

    @Override
    public void refresh() {
        super.refresh();
    }

    @Override
    public void onStart() {
        super.onStart();
        this.prepareClearCacheAction();
        this.showGPCheckBox.setSelected(false);
    }

    @Override
    protected void postRefresh() {
        super.postRefresh();
        this.getSearcherTranslator().updateTranslation((AbstractSearcher<? extends PersistentObjectI>)this.compiler.getSearcher());
    }

    public final JXTable getTable() {
        return this.getCentralArea().getTable();
    }

    @Override
    public EventList<ItemUnsoldReport> getObjectList() {
        return super.getObjectList();
    }

    private Action getExportAction() {
        return new CSVExportAction<ItemUnsoldReport>(this.getObjectList(), this.getColumnFormat(), "UnSoldItems.csv");
    }

    public ItemUnsoldReportCompiler getCompiler() {
        return this.compiler;
    }

    private void prepareClearCacheAction() {
        if (this.getUser().hasPermission(AllPermissions.GOD_ONLY)) {
            if (this.clearAction == null) {
                this.clearAction = new ClearCacheAction("Clear Cache", new ImageResizeHelper().rescaleImageIcon(IconLoader.get((String)"/officemate/images/bomb.png"), 0.5));
                this.clearAction.setPermission(AllPermissions.GOD_ONLY);
            }
            if (!this.getDefaultActions().contains((Object)this.clearAction)) {
                this.addAction((Action)((Object)this.clearAction));
            }
        } else if (this.clearAction != null) {
            this.removeStateSpecificAction((Action)((Object)this.clearAction));
        }
    }

    static class PriceCellRenderer
    extends DefaultTableCellRenderer {
        PriceCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object localValue = value;
            try {
                localValue = Price.parsePrice((String)value.toString());
            }
            catch (NumberFormatException ex) {
                OrderMate.LOG.warn("Could not parse price " + value, (Throwable)ex);
            }
            return super.getTableCellRendererComponent(table, localValue, isSelected, hasFocus, row, column);
        }
    }
}

