/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.jasper;

import ar.com.fdvs.dj.domain.builders.BuilderException;
import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.FixedRangeSearchFilter;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.util.OffsetFunction;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import officemate.screens.reports.jasper.JasperReportState;
import officemate.screens.reports.jasper.JasperToolbarFactory;
import ordermate.OrderMate;
import ordermate.database.searchers.reports.DateSearcher;
import ordermate.database.users.Permission;
import ordermate.reports.dynamicjasper.reportbuilder.DynamicReportProvider;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;

public abstract class AbstractPeriodJasperReportState<T extends PersistentObjectI, S extends DateSearcher<T>>
extends JasperReportState {
    private EventList dates;
    private final DynamicReportProvider reportProvider;

    public AbstractPeriodJasperReportState(DynamicReportProvider reportBuilder, String stateName, Permission permission, String description) {
        super((ReportProvider)reportBuilder, stateName, permission, description);
        this.reportProvider = reportBuilder;
    }

    @Override
    protected void init() {
        super.init();
    }

    @Override
    public JasperToolbarFactory createJasperToolbarFactory() {
        return new JasperToolbarFactory(){

            @Override
            protected JPanel getCustomReportControlPanel() {
                return AbstractPeriodJasperReportState.this.createCustomReportControlPanel(new JPanel());
            }
        };
    }

    protected JPanel createCustomReportControlPanel(JPanel panel) {
        FixedRangeSearchFilter searchProp = new FixedRangeSearchFilter((IRangedQuerySearchFilter)this.getSearcher().getTradingDayDateRangeFilter(), this.getDateOffset());
        RefreshAction refresh = new RefreshAction((Refreshable)this);
        this.dates = GlazedLists.eventList(new ArrayList(this.getDateList()));
        ComboSearchField field = new ComboSearchField(this.getComboLabel(), (ISingleValueSearchFilter)searchProp, false, (Action)refresh, this.dates, this.constructFormatter());
        panel.add(field.getJLabelForComponent());
        panel.add(field.getGuiComponent());
        return panel;
    }

    protected String getComboLabel() {
        return this.getLabel();
    }

    @Override
    public void refresh() {
        Date date = (Date)this.getSearcher().getTradingDayDateRangeFilter().getStart();
        String dateString = this.constructFormatter().format(date);
        try {
            this.reportProvider.getBuilder().setTitle(this.getName() + " " + (dateString != null ? dateString : "No Date Set"));
        }
        catch (BuilderException ex) {
            OrderMate.LOG.warn("Exception caught setting the date on the report.", (Throwable)ex);
            return;
        }
        GlazedListUtils.setAsList((EventList)this.dates, new ArrayList(this.getDateList()));
        super.refresh();
    }

    protected abstract OffsetFunction getDateOffset();

    protected abstract S getSearcher();

    protected abstract String getLabel();

    protected abstract List getDateList();

    protected abstract Format constructFormatter();
}

