/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.periodtrend;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.gui.renderer.StringifierListCellRenderer;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.util.FormatStringifier;
import au.com.ordermate.util.Stringifier;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import officemate.screens.reports.jasper.JasperReportState;
import officemate.screens.reports.jasper.JasperToolbarFactory;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.ConfigShift;
import ordermate.database.reports.periodtrend.PeriodTrendReportCompiler;
import ordermate.database.reports.periodtrend.PeriodTrendReportProvider;
import ordermate.database.users.AllPermissions;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.model.NullableEventComboBoxModel;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;

public abstract class PeriodTrendReportState
extends JasperReportState
implements ActionListener {
    private JComboBox timeBlockCombo;
    private JComboBox dayOfWeekCombo;
    private JComboBox shiftCombo;
    private JCheckBox cumulativeCheck;
    private MultiSelectComboSearchField salesLocationField;
    private JComboBox fromCombo;
    private JComboBox toCombo;
    private boolean latch = false;
    private PeriodReportAdapter period;

    public PeriodTrendReportState(PeriodReportAdapter period) {
        super((ReportProvider)new PeriodTrendReportProvider(), period.getLabel() + " Period Trend", AllPermissions.ACCESS_SALES_REPORT, "Show sales by period block versus time block");
        ((PeriodTrendReportProvider)this.getProvider()).getCompiler().setPeriod(period);
        this.period = period;
        this.latch = true;
    }

    @Override
    public JasperToolbarFactory createJasperToolbarFactory() {
        return new JasperToolbarFactory(){

            @Override
            protected JPanel getCustomReportControlPanel() {
                return PeriodTrendReportState.this.createCustomReportControlPanel();
            }
        };
    }

    protected JPanel createCustomReportControlPanel() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        List searchDates = this.period.getDateList();
        JPanel dateHolder = new JPanel();
        this.fromCombo = new JComboBox<Object>(searchDates.toArray());
        this.fromCombo.setRenderer(new StringifierListCellRenderer((Stringifier)new FormatStringifier((Format)this.period.getFormatter(), Date.class)));
        this.fromCombo.setSelectedItem(searchDates.get(Math.min(searchDates.size(), 4)));
        this.fromCombo.setPreferredSize(new Dimension(150, 30));
        ComponentUtils.setupComboBox((JComboBox)this.fromCombo);
        this.toCombo = new JComboBox<Object>(searchDates.toArray());
        this.toCombo.setRenderer(new StringifierListCellRenderer((Stringifier)new FormatStringifier((Format)this.period.getFormatter(), Date.class)));
        this.toCombo.setPreferredSize(new Dimension(150, 30));
        ComponentUtils.setupComboBox((JComboBox)this.toCombo);
        dateHolder.add(new JLabel("From"));
        dateHolder.add(this.fromCombo);
        dateHolder.add(new JLabel("To"));
        dateHolder.add(this.toCombo);
        builder.addRow("Date Range", (Component)dateHolder);
        if (this.isShowDayOfWeek()) {
            Calendar cal = Calendar.getInstance();
            cal.set(7, 2);
            Object[] dates = new Object[7];
            for (int i = 0; i < 7; ++i) {
                dates[i] = cal.getTime();
                cal.add(7, 1);
            }
            NullableEventComboBoxModel model = new NullableEventComboBoxModel(GlazedLists.eventListOf((Object[])dates), (Object)"Any");
            this.dayOfWeekCombo = new JComboBox(model);
            FormatStringifier format = new FormatStringifier((Format)new SimpleDateFormat("EE"), Date.class);
            this.dayOfWeekCombo.setRenderer(new StringifierListCellRenderer((Stringifier)format));
            this.dayOfWeekCombo.addActionListener(this);
            ComponentUtils.setupComboBox((JComboBox)this.dayOfWeekCombo);
            builder.addRow("Day Of Week", (Component)this.dayOfWeekCombo);
        }
        this.timeBlockCombo = new JComboBox<Integer>(new Integer[]{60, 30, 20, 15, 10, 5, 1, 120, 240, 360, 480});
        builder.addRow("Minute Block", (Component)this.timeBlockCombo);
        this.timeBlockCombo.addActionListener(this);
        ComponentUtils.setupComboBox((JComboBox)this.timeBlockCombo);
        if (ConfigShift.getAllConfigShifts().size() > 1) {
            NullableEventComboBoxModel model = new NullableEventComboBoxModel(GlazedLists.eventList((Collection)ConfigShift.getAllConfigShifts()), (Object)"Any");
            this.shiftCombo = new JComboBox(model);
            this.shiftCombo.addActionListener(this);
            ComponentUtils.setupComboBox((JComboBox)this.shiftCombo);
            builder.addRow("Shift", (Component)this.shiftCombo);
        }
        this.cumulativeCheck = new JCheckBox();
        this.cumulativeCheck.addActionListener(this);
        builder.addRow("Cumulative", (Component)this.cumulativeCheck);
        this.salesLocationField = new MultiSelectComboSearchField("Sales Location", ((PeriodTrendReportProvider)this.getProvider()).getCompiler().getSalesLocationFilter(), null, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations()));
        builder.addRow("Sales Location", (Component)this.salesLocationField.getGuiComponent());
        return builder.getPanel();
    }

    protected boolean isShowDayOfWeek() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.refresh();
    }

    @Override
    public void refresh() {
        Object value;
        if (!this.latch) {
            return;
        }
        PeriodTrendReportProvider provider = (PeriodTrendReportProvider)this.getProvider();
        PeriodTrendReportCompiler compiler = provider.getCompiler();
        compiler.setCumulative(this.cumulativeCheck.isSelected());
        compiler.setMinuteFactor(((Integer)this.timeBlockCombo.getSelectedItem()).intValue());
        if (this.isShowDayOfWeek() && (value = this.dayOfWeekCombo.getSelectedItem()) != null && !"Any".equals(value)) {
            compiler.getSearcher().getDayOfWeekFilter().setSearchValue((Object)((Date)value));
        }
        compiler.getDateRangeFilter().setStart((Comparable)((Date)this.fromCombo.getSelectedItem()));
        compiler.getDateRangeFilter().setEnd((Comparable)((Date)this.toCombo.getSelectedItem()));
        if (this.shiftCombo != null) {
            compiler.getSearcher().getShiftFilter().setSearchValue(this.shiftCombo.getSelectedItem());
        }
        compiler.getSearcher().getSalesLocationFilter().setSearchValue((Object)this.salesLocationField.getRenderer().getSelectionEventList());
        super.refresh();
    }
}

