/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.reconciliation;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;
import officemate.OfficeMate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.EditorDialog;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.TableStateCentralArea;
import officemate.screens.reports.reconciliation.BankingPanel;
import officemate.screens.reports.reconciliation.CoversPanel;
import officemate.screens.reports.reconciliation.ShiftReconciliationEditPanel;
import officemate.screens.reports.reconciliation.ShiftReconciliationSignatureEditPanel;
import officemate.screens.reports.reconciliation.ShiftReconciliationTable;
import officemate.screens.reports.reconciliation.TotalsPanel;
import officemate.screens.reports.reconciliation.skims.SkimsTransactionTable;
import ordermate.OrderMate;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.OpenAccountInReconciliationStrategy;
import ordermate.database.reports.finance.CashDrawerDenominationAggregateReportProvider;
import ordermate.database.reports.finance.DenominationReportCompiler;
import ordermate.database.reports.finance.DenominationReportMaker;
import ordermate.database.reports.reconciliation.ReconciliationReportMaker;
import ordermate.database.sales.Account;
import ordermate.database.users.AllPermissions;
import ordermate.gui.binding.ColumnVisibilityHelper;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.reports.printing.HeaderSubReport;
import ordermate.reports.printing.PrintUtilities;
import ordermate.scheduler.AutoSender;
import org.jdesktop.swingx.VerticalLayout;

public class ReconciliationState
extends AbstractTableState {
    private static HeaderSubReport subReport = null;
    private ShiftReconciliationTable centralArea;
    private TotalsPanel totalsPanel;
    private CoversPanel coversPanel;
    private SkimsTransactionTable skims;
    private BankingPanel bankingPanel;
    private ObjectEditor editor = new ShiftReconciliationEditPanel();
    private EditorDialog editorDialog;
    private ObjectEditor editorSignature = new ShiftReconciliationSignatureEditPanel();
    private EditorDialog editorSignatureDialog;
    private ComboSearchField shiftSelectorCombo;
    private final EventList<ShiftReconciliation> shiftReconciliationList = new BasicEventList();
    private volatile ShiftReconciliation currentReconciliation;
    private final MarkCompletedAction completedAction;
    private boolean addHead = true;

    public ReconciliationState() {
        super("Reconciliation", AllPermissions.MYTILLS_RECONCILIATION, "Reconcile money received.");
        this.addAction((Action)((Object)new NewAction()));
        this.addAction((Action)((Object)new SignatureAction()));
        this.completedAction = new MarkCompletedAction();
        this.addAction((Action)((Object)this.completedAction));
        this.addAction((Action)new BasicAction("Denomination Report", IconLoader.get((String)"/ordermate/images/view_report.png"), "Produces a report breaking down this reconciliation by denomination for each cashdrawer"){

            public void actionPerformed(ActionEvent e) {
                ReconciliationState.this.doDenominationReport();
            }
        });
    }

    public TableStateCentralArea createCentralArea() {
        this.centralArea = new ShiftReconciliationTable(this, this.getObjectList());
        JPanel northPanel = new JPanel();
        JPanel searchPanel = this.getSearchFactory().getSearchPanel();
        JPanel controlPanel = new JPanel();
        ColumnVisibilityHelper varianceCheckHelper = new ColumnVisibilityHelper((Object[])CashdrawerReconciliation.VARIANCE_PROPERTIES, new JCheckBox("Show Variance"), this.centralArea.getTable());
        ColumnVisibilityHelper systemCheckHelper = new ColumnVisibilityHelper((Object[])CashdrawerReconciliation.SYSTEM_TOTAL_PROPERTIES, new JCheckBox("Show System Totals"), this.centralArea.getTable());
        ColumnVisibilityHelper userCheckHelper = new ColumnVisibilityHelper((Object[])new PropertiedObject.Property[]{CashdrawerReconciliation.Properties.USERS}, new JCheckBox("Show Users"), this.centralArea.getTable());
        StandardSecurityDecorator decoratedVariance = new StandardSecurityDecorator((JComponent)varianceCheckHelper.getCheckBox(), AllPermissions.VIEW_TAKINGS);
        controlPanel.add((Component)decoratedVariance);
        StandardSecurityDecorator decoratedSystemTotals = new StandardSecurityDecorator((JComponent)systemCheckHelper.getCheckBox(), AllPermissions.VIEW_TAKINGS);
        controlPanel.add((Component)decoratedSystemTotals);
        controlPanel.add(userCheckHelper.getCheckBox());
        northPanel.setLayout(new BorderLayout());
        northPanel.add((Component)searchPanel, "Center");
        northPanel.add((Component)controlPanel, "East");
        this.centralArea.setSearchBar(northPanel);
        return this.centralArea;
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.editorDialog = new EditorDialog("Shift Reconciliation", this.editor);
        this.editorSignatureDialog = new EditorDialog("Shift Reconciliation", this.editorSignature);
    }

    @Override
    public void setScreenPanel(JComponent panel) {
        JPanel screenPanel = new JPanel(new GridLayout(2, 1));
        screenPanel.add(panel);
        JPanel southPanel = new JPanel();
        southPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        southPanel.setLayout(new GridLayout(2, 2));
        JPanel skimsPanel = new JPanel();
        skimsPanel.setLayout(new BorderLayout());
        skimsPanel.add((Component)new JLabel("<HTML><B>SKIMS</B></HTML>"), "North");
        skimsPanel.add((Component)this.getSkimsTable(), "Center");
        skimsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        southPanel.add((Component)skimsPanel, new Rectangle(0, 0, 1, 1));
        StandardSecurityDecorator coversSecurity = new StandardSecurityDecorator((JComponent)this.getCoversPanel(), AllPermissions.VIEW_TAKINGS);
        southPanel.add((Component)coversSecurity, new Rectangle(1, 0, 1, 1));
        StandardSecurityDecorator totalSecurity = new StandardSecurityDecorator((JComponent)this.getTotalsPanel(), AllPermissions.VIEW_TAKINGS);
        southPanel.add((Component)totalSecurity, new Rectangle(0, 1, 1, 1));
        StandardSecurityDecorator bankingSecurity = new StandardSecurityDecorator((JComponent)this.getBankingPanel(), AllPermissions.VIEW_TAKINGS);
        southPanel.add((Component)bankingSecurity, new Rectangle(1, 1, 1, 1));
        screenPanel.add(southPanel);
        super.setScreenPanel(screenPanel);
        southPanel.validate();
    }

    public Class<CashdrawerReconciliation> getDisplayingType() {
        return CashdrawerReconciliation.class;
    }

    public OfficeMateObjectSearch createSearchPanelFactory() {
        new SwingWorker(){

            protected Object doInBackground() throws Exception {
                return PersistenceManager.getObjectList(Shift.class, (String)Query.select(Shift.class).linkUsing(ShiftReconciliation.Properties.SHIFT).limit(30).orderByDesc(Shift.Properties.ID).toString(), (Object[])new Object[0]);
            }
        }.execute();
        ObjectPropertySearch<CashdrawerReconciliation> state = new ObjectPropertySearch<CashdrawerReconciliation>(this.getDisplayingType()){

            @Override
            public void reaquireSearchOptions() {
                OfficeMateAdminGuiUtils.getInstance().refreshList(ReconciliationState.this.shiftReconciliationList, ShiftReconciliation.Reports.getShiftReconciliations());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doRefresh() {
                this.clearObjectList();
                ShiftReconciliation selectedRecon = (ShiftReconciliation)ReconciliationState.this.shiftSelectorCombo.getSelectedObject();
                if (selectedRecon != null) {
                    selectedRecon = (ShiftReconciliation)PersistenceManager.reacquire((PersistentObjectI)selectedRecon);
                    3 var2_2 = this;
                    synchronized (var2_2) {
                        ReconciliationState.this.currentReconciliation = selectedRecon;
                    }
                    final ShiftReconciliation theSelectedRecon = selectedRecon;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int index = ReconciliationState.this.shiftReconciliationList.indexOf((Object)theSelectedRecon);
                            ReconciliationState.this.shiftReconciliationList.set(index, (Object)theSelectedRecon);
                            this.copyIntoObjectList(theSelectedRecon.getCashDrawerReconciliations());
                        }
                    });
                }
            }

            @Override
            public void refresh() {
                super.refresh(new Runnable(){

                    @Override
                    public void run() {
                        ReconciliationState.this.postRefresh();
                    }
                });
            }
        };
        state.reaquireSearchOptions();
        RefreshAction action = new RefreshAction((Refreshable)state);
        this.shiftSelectorCombo = new ComboSearchField("Shift :", CashdrawerReconciliation.Properties.PARENT, false, (Action)action, this.shiftReconciliationList);
        state.addSearchField((SearchGuiField)this.shiftSelectorCombo);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ShiftReconciliation createNewReconciliation() {
        ReconciliationState reconciliationState = this;
        synchronized (reconciliationState) {
            this.currentReconciliation = new ShiftReconciliation(ShiftReconciliation.Reports.getRecentShiftWithoutReconciliation(), GuiApp.getAppComplex().getApplicationSecurity().getUser());
        }
        return this.currentReconciliation;
    }

    @Override
    public void refresh() {
        super.refresh();
    }

    @Override
    protected void postRefresh() {
        super.postRefresh();
        this.refreshReports();
        boolean completed = this.getCurrentShiftReconciliation() != null ? this.getCurrentShiftReconciliation().isCompleted() : false;
        this.completedAction.setEnabled(!completed);
        this.getCentralArea().getTable().setEnabled(!completed || GuiApp.getAppComplex().getApplicationSecurity().getUser().hasPermission(AllPermissions.EDIT_COMPLETED_RECONCILIATIONS));
    }

    private void refreshReports() {
        ShiftReconciliation shiftReconciliation = this.getCurrentShiftReconciliation();
        this.getTotalsPanel().setShiftReconciliation(shiftReconciliation);
        this.getCoversPanel().setShiftReconciliation(shiftReconciliation);
        if (shiftReconciliation != null) {
            this.getSkimsTable().setShift(shiftReconciliation.getShift());
        } else {
            this.getSkimsTable().setShift(null);
        }
        this.getBankingPanel().setShiftReconciliation(shiftReconciliation);
    }

    private synchronized ShiftReconciliation getCurrentShiftReconciliation() {
        return this.currentReconciliation;
    }

    protected TotalsPanel getTotalsPanel() {
        if (this.totalsPanel == null) {
            this.totalsPanel = new TotalsPanel();
        }
        return this.totalsPanel;
    }

    protected CoversPanel getCoversPanel() {
        if (this.coversPanel == null) {
            this.coversPanel = new CoversPanel();
        }
        return this.coversPanel;
    }

    protected SkimsTransactionTable getSkimsTable() {
        if (this.skims == null) {
            this.skims = new SkimsTransactionTable();
        }
        return this.skims;
    }

    protected BankingPanel getBankingPanel() {
        if (this.bankingPanel == null) {
            this.bankingPanel = new BankingPanel();
        }
        return this.bankingPanel;
    }

    public String getTypeName() {
        return "Shift reconciliation";
    }

    private String getErrorMessageForOpenAccountsHandled(int openAccountsCount) {
        return String.format("Sorry! There %s %d account%s already open.", openAccountsCount == 1 ? "is" : "are", openAccountsCount, openAccountsCount == 1 ? "" : "s");
    }

    private String getWarningMessageForOpenAccountsHandled(int openAccountsCount) {
        return String.format("There %s %d account%s open. Would you like to proceed ?", openAccountsCount == 1 ? "is" : "are", openAccountsCount, openAccountsCount == 1 ? "" : "s");
    }

    private boolean isOpenAccountsHandled() {
        JFrame currentFrame = GuiApp.getAppComplex().getApplicationFrame().getFrame();
        List openAccounts = Account.getAllOpenAccounts();
        int openAccountsCount = openAccounts == null ? 0 : openAccounts.size();
        String warningMessage = this.getWarningMessageForOpenAccountsHandled(openAccountsCount);
        String errorMessage = this.getErrorMessageForOpenAccountsHandled(openAccountsCount);
        if (openAccountsCount <= 0) {
            return false;
        }
        OpenAccountInReconciliationStrategy strategy = SystemProperty.getInstance().getOpenAccountInReconciliationStrategy();
        if (OpenAccountInReconciliationStrategy.IGNORE.equals((Object)strategy)) {
            return false;
        }
        if (OpenAccountInReconciliationStrategy.WARN.equals((Object)strategy)) {
            int userOption = JOptionPane.showConfirmDialog(currentFrame, warningMessage, "Warning", 0, 2);
            return userOption != 0;
        }
        if (OpenAccountInReconciliationStrategy.PREVENT.equals((Object)strategy)) {
            Dialogs.showErrorDialog("Error", errorMessage);
            return true;
        }
        return false;
    }

    private void createNewReconciliationAction() {
        ShiftReconciliation newRecon = this.createNewReconciliation();
        this.editor.setObject((Object)newRecon);
        if (this.editorDialog.doModal()) {
            this.editor.saveObject();
            newRecon.save();
            this.shiftReconciliationList.add(0, (Object)newRecon);
            ShiftReconciliation.Reports.clearLocalListCaches();
            this.shiftSelectorCombo.setSelectedObject((Object)newRecon);
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPrintAction() {
        this.prepareReport();
        JComponent component = this.getScreenPanel();
        Container parent = component.getParent();
        parent.remove(component);
        try {
            if (this.addHead) {
                JPanel panel = new JPanel(new BorderLayout());
                JPanel reportPanel = this.generateJPanel(subReport);
                reportPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
                panel.add((Component)reportPanel, "North");
                panel.add((Component)component, "Center");
                panel.setPreferredSize(new Dimension(1000, 1414));
                panel.validate();
                JDialog previewDlg = new JDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame());
                previewDlg.add(panel);
                previewDlg.pack();
                PrintUtilities.printComponent((Component)panel);
                panel.remove(component);
            } else {
                PrintUtilities.printComponent((Component)component);
            }
        }
        catch (Exception e1) {
            OrderMate.LOG.error("Error printing", (Throwable)e1);
            Dialogs.showErrorDialog("Error printing", "An error occured while printing");
        }
        finally {
            parent.add(component);
            parent.invalidate();
            this.refresh();
        }
    }

    private JPanel generateJPanel(HeaderSubReport report) {
        BusinessInfo info = BusinessInfo.getInstance();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.WHITE);
        Image logo = report.getLogo();
        if (logo != null) {
            JLabel logoLabel = new JLabel(new ImageIcon(logo));
            ImageIcon icon = new ImageIcon(report.getLogo());
            if (logo.getHeight(logoLabel) > 200) {
                logoLabel = new JLabel(new ImageIcon(logo.getScaledInstance(-1, 200, 4)));
            }
            panel.add((Component)logoLabel, "West");
        }
        String phoneString = "";
        if (info.getPhone() != null && !info.getPhone().equalsIgnoreCase("")) {
            phoneString = info.getPhone();
        }
        JPanel eastPanel = new JPanel((LayoutManager)new VerticalLayout());
        eastPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        eastPanel.setBackground(Color.WHITE);
        eastPanel.add(new JLabel("<HTML><H2>" + info.getName() + "</H2>" + info.getBusinessNumberType() + ": " + info.getAbn() + "<P>" + BusinessInfo.getInstance().getAddress1() + "<BR>" + BusinessInfo.getInstance().getAddress2() + "<P><P>" + phoneString + "</HTML>"));
        panel.add((Component)eastPanel, "East");
        return panel;
    }

    private void prepareReport() {
        if (this.addHead && subReport == null) {
            try {
                subReport = new HeaderSubReport();
                subReport.generate();
            }
            catch (Exception ex) {
                this.addHead = false;
                OfficeMate.LOG.error("Could not initialize report header.", (Throwable)ex);
            }
        }
    }

    private void doDenominationReport() {
        final Shift shift = ((ShiftReconciliation)this.shiftSelectorCombo.getSelectedObject()).getShift();
        if (shift == null) {
            Dialogs.showInfoDialog("No Shift", "Please select a shift first");
            return;
        }
        Dialogs.showProgressDialog(new AbstractTask(){

            protected int getTotalSubTasks() {
                return 1;
            }

            protected void performTask() throws Exception {
                DenominationReportCompiler compiler = new DenominationReportCompiler();
                CashDrawerDenominationAggregateReportProvider provider = new CashDrawerDenominationAggregateReportProvider(compiler);
                compiler.getSearcher().getShiftFilter().setSearchValue((Object)shift);
                try {
                    JasperPrint print = provider.getReportPrint();
                    if (print != null) {
                        JasperViewer.viewReport((JasperPrint)print, (boolean)false);
                    }
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("cannot view denominations report", (Throwable)ex);
                    Dialogs.showErrorDialog("Cannot view report", "The Denominations report for this shift cannot be viewed. Please contact OrderMate.");
                }
            }

            public String getName() {
                return "Denominations Report";
            }
        });
    }

    @Override
    public boolean supportsPrint() {
        return true;
    }

    private class MarkCompletedAction
    extends BasicAction {
        public MarkCompletedAction() {
            super("Mark as Completed", (Icon)IconLoader.get((String)"/ordermate/images/button_ok.png"), "Marks this reconciliation as completed");
        }

        public void actionPerformed(ActionEvent e) {
            if (ReconciliationState.this.isOpenAccountsHandled()) {
                return;
            }
            ShiftReconciliation shift = ReconciliationState.this.getCurrentShiftReconciliation();
            if (Dialogs.showChoiceDialog("Mark Reconciliation Completed", "<html>You may be unable to edit this Reconciliation once its marked completed.<br><br>Are you sure you want to mark this Reconciliation as completed ?</html>")) {
                shift.setCompleted(true);
                shift.save();
                AutoSender.getInstance().emailReport(ReconciliationReportMaker.class);
                AutoSender.getInstance().emailReport(DenominationReportMaker.class);
                ReconciliationState.this.refresh();
            }
        }
    }

    private class SignatureAction
    extends BasicAction {
        public SignatureAction() {
            super("Signature", (Icon)IconLoader.get((String)"/ordermate/images/keys.png"), "Set the signatures");
        }

        public void actionPerformed(ActionEvent e) {
            ShiftReconciliation shift = ReconciliationState.this.getCurrentShiftReconciliation();
            ReconciliationState.this.editorSignature.setObject((Object)shift);
            if (ReconciliationState.this.editorSignatureDialog.doModal()) {
                ReconciliationState.this.editorSignature.saveObject();
                shift.save();
                ReconciliationState.this.refresh();
            }
        }
    }

    private class NewAction
    extends BasicAction {
        public NewAction() {
            super("New", (Icon)IconLoader.get((String)"/ordermate/images/new_icon22.png"), "Create New");
        }

        public void actionPerformed(ActionEvent e) {
            if (ReconciliationState.this.isOpenAccountsHandled()) {
                return;
            }
            ReconciliationState.this.createNewReconciliationAction();
        }
    }
}

