/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.reconciliation;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.util.HtmlBuilder;
import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.Format;
import javax.swing.JComponent;
import officemate.components.EditorDialog;
import officemate.components.table.PersistentObjectTable;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.PropertyAccessorColumnFormat;
import officemate.components.tableformat.textformat.DisplayableListFormat;
import officemate.screens.reports.reconciliation.ReconciliationState;
import officemate.screens.reports.reconciliation.entryeditor.AbstractEntryEditor;
import officemate.screens.reports.reconciliation.entryeditor.EntryEditor;
import officemate.screens.reports.reconciliation.entryeditor.EntryEditorPanelVendor;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.swingx.JXTable;

public class ShiftReconciliationTable
extends PersistentObjectTable {
    private final ReconciliationState parent;
    private static final PropertiedObject.Property[] defaultHiddenProps = new PropertiedObject.Property[]{CashdrawerReconciliation.Properties.USERS};

    public ShiftReconciliationTable(ReconciliationState theParent, EventList list) {
        super(list, new CashdrawerReconciliationColumnFormat(), defaultHiddenProps);
        this.parent = theParent;
        this.setupMouseListener();
        this.getTable().setColumnControlVisible(false);
    }

    public void setSearchBar(JComponent searchBar) {
        this.add((Component)searchBar, "North");
    }

    private void editCell(int row, int col) {
        PropertiedObject.Property prop = this.getColumnProperty(col);
        if (prop != null) {
            CashdrawerReconciliation reconciliation = (CashdrawerReconciliation)this.getObjectAt(row);
            this.doEditProperty(reconciliation, prop);
        }
    }

    private void doEditProperty(CashdrawerReconciliation recon, PropertiedObject.Property prop) {
        if (prop.getOwner() != CashdrawerReconciliation.class) {
            return;
        }
        AbstractEntryEditor editor = EntryEditorPanelVendor.getInstance().getEditor(prop);
        if (editor != null) {
            editor.setCashdrawerReconciliation(recon);
            this.doEditDlg(editor);
        } else if (Config.getBooleanValue((String)"debug")) {
            // empty if block
        }
    }

    private void doEditDlg(EntryEditor editor) {
        EditorDialog editorDialog = this.createEditorDialog(editor, "");
        if (editor.getDefaultButton() != null) {
            editorDialog.setDefaultButton(editor.getDefaultButton());
        }
        if (editorDialog.doModal()) {
            editor.save();
        }
        this.parent.refresh();
    }

    public EditorDialog createEditorDialog(ObjectEditor editor, String typeName) {
        EditorDialog dialog = new EditorDialog(typeName, editor);
        dialog.setHeaderText("Edit a reconciliation entry");
        return dialog;
    }

    private void setupMouseListener() {
        this.getTable().setSelectionMode(0);
        this.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getComponent().equals(ShiftReconciliationTable.this.getTable())) {
                    JXTable table = ShiftReconciliationTable.this.getTable();
                    int selectedRow = table.getSelectedRow();
                    int selectedCol = table.getSelectedColumn();
                    if (selectedCol >= 0 && selectedRow >= 0) {
                        ShiftReconciliationTable.this.editCell(selectedRow, selectedCol);
                    }
                }
            }
        });
    }

    protected ShiftReconciliation getShiftReconciliation() {
        CashdrawerReconciliation cashRecon;
        if (this.getObjectCount() > 0 && (cashRecon = (CashdrawerReconciliation)this.getObjectAt(0)) != null) {
            return cashRecon.getParent();
        }
        return null;
    }

    protected static class CashdrawerReconciliationColumnFormat
    extends ColumnTableFormat {
        public static final String USERS_COLNAME = "Users";
        public static final String CASH_DRAWER_COLNAME = "<HTML>Cash<BR>Drawer</HTML>";
        public static final String TERMINAL_COLNAME = "Terminal";

        public CashdrawerReconciliationColumnFormat() {
            super(new ColumnFormat[]{new PropertyAccessorColumnFormat(TERMINAL_COLNAME, CashdrawerReconciliation.Properties.CASHDRAWER, CashDrawer.Properties.HOST), new PropertyColumnFormat(CASH_DRAWER_COLNAME, CashdrawerReconciliation.Properties.CASHDRAWER), new PropertyColumnFormat(USERS_COLNAME, (PropertyAccessor)CashdrawerReconciliation.Properties.USERS, (Format)new DisplayableListFormat()), new PropertyColumnFormat("Float", CashdrawerReconciliation.Properties.FLOAT_ENTRY), new PropertyColumnFormat("<HTML>Over<BR>Ring</HTML>", CashdrawerReconciliation.Properties.OVERRING_ENTRY), new PropertyColumnFormat("<HTML>Skims</HTML>", (PropertiedObject.Property)CashdrawerReconciliation.Properties.TOTAL_SKIMS), new PropertyColumnFormat("<HTML>Actual<BR>Cash</HTML>", (PropertiedObject.Property)CashdrawerReconciliation.Properties.ACTUAL_CASH_TOTAL), new PropertyColumnFormat("<HTML>Petty<BR>Cash</HTML>", (PropertiedObject.Property)CashdrawerReconciliation.Properties.PETTY_CASH_TOTAL), new PropertyColumnFormat("<HTML>System<BR>Cash</HTML>", (PropertiedObject.Property)CashdrawerReconciliation.Properties.SYSTEM_CASH), new PropertyColumnFormat("<HTML>Cash<BR>Variance</HTML>", (PropertiedObject.Property)CashdrawerReconciliation.Properties.CASH_VARIANCE), new PropertyColumnFormat("Credit", (PropertiedObject.Property)CashdrawerReconciliation.Properties.CREDIT_TOTAL), new PropertyColumnFormat("<HTML>System<BR>Credit</HTML>", (PropertiedObject.Property)CashdrawerReconciliation.Properties.SYSTEM_CREDIT), new PropertyColumnFormat("<HTML>Credit<BR>Variance</HTML>", (PropertiedObject.Property)CashdrawerReconciliation.Properties.CREDIT_VARIANCE), new PropertyColumnFormat("<HTML>Cash<BR>Out</HTML>", CashdrawerReconciliation.Properties.CASH_OUT_ENTRY), new PropertyColumnFormat("<HTML>System<BR>Cashout</HTML>", (PropertiedObject.Property)CashdrawerReconciliation.Properties.SYSTEM_CASH_OUT), new PropertyColumnFormat("Web", (PropertiedObject.Property)CashdrawerReconciliation.Properties.WEB_TOTAL), new PropertyColumnFormat("<HTML>System<BR>Web</HTML>", (PropertiedObject.Property)CashdrawerReconciliation.Properties.SYSTEM_WEB), new PropertyColumnFormat("<HTML>Web<BR>Variance</HTML>", (PropertiedObject.Property)CashdrawerReconciliation.Properties.WEB_VARIANCE), new PropertyColumnFormat("Tips", (PropertiedObject.Property)CashdrawerReconciliation.Properties.TIPS_TOTAL), new PropertyColumnFormat("<HTML>System<BR>Tips</HTML>", (PropertiedObject.Property)CashdrawerReconciliation.Properties.SYSTEM_TIPS), new PropertyColumnFormat("<HTML>Total</HTML>", (PropertiedObject.Property)CashdrawerReconciliation.Properties.ALL_COMPONENTS_TOTAL), new PropertyColumnFormat("<HTML>System<BR>Total</HTML>", (PropertiedObject.Property)CashdrawerReconciliation.Properties.SYSTEM_TOTAL), new PropertyColumnFormat("<HTML>Total<BR>Variance</HTML>", (PropertiedObject.Property)CashdrawerReconciliation.Properties.TOTAL_VARIANCE), new PropertyColumnFormat(new HtmlBuilder().append("System").appendLineBreak().append("Voucher Redeems").toString(), (PropertiedObject.Property)CashdrawerReconciliation.Properties.SYSTEM_VOUCHER)});
        }
    }
}

