/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.reconciliation.entryeditor;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import officemate.screens.reports.reconciliation.entryeditor.AbstractEntryEditor;
import ordermate.database.finance.Denomination;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.entries.ActualCashEntry;
import ordermate.database.finance.reconciliation.entries.FloatEntry;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.converter.PriceToStringConverter;
import ordermate.gui.binding.converter.TotalToUnitDenominationConverter;
import ordermate.gui.binding.validators.DenominationValidator;
import ordermate.internationalization.Internationalization;
import org.jdesktop.beansbinding.AbstractBindingListener;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingListener;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.Validator;

public class ActualCashEntryEditor
extends AbstractEntryEditor {
    private HashMap denominationTextFields = new HashMap();
    private JTextField grandTotalField;
    private JTextField floatField;
    private JTextField totalLessFloatField;

    public ActualCashEntryEditor() {
        FieldPanelBuilder builder = this.getFieldPanelBuilder();
        Denomination[] denominations = Denomination.getDenominations();
        for (int i = 0; i < denominations.length; ++i) {
            builder.addRow(denominations[i].getLabel(), (Component)this.getEntryField(denominations[i]));
        }
        builder.addSeparator("Total");
        JPanel thePanel = new JPanel(new BorderLayout());
        thePanel.add((Component)builder.getPanel(), "Center");
        thePanel.add((Component)this.constructTotalPanel(), "South");
        this.add(thePanel);
    }

    private JPanel constructTotalPanel() {
        this.grandTotalField = new JTextField(7);
        this.grandTotalField.setEditable(false);
        this.grandTotalField.setName("grandTotalField");
        JLabel totalLabel = new JLabel("Total: ");
        totalLabel.setLabelFor(this.grandTotalField);
        this.floatField = new JTextField(7);
        this.floatField.setEditable(false);
        JLabel floatLabel = new JLabel("Float: ");
        floatLabel.setLabelFor(this.floatField);
        this.totalLessFloatField = new JTextField(7);
        this.totalLessFloatField.setEditable(false);
        JLabel totalLessFloatLabel = new JLabel("<HTML>Total <BR>less Float :</HTML");
        totalLessFloatLabel.setLabelFor(this.totalLessFloatField);
        JPanel totalPanel = new JPanel(new FlowLayout(1));
        totalPanel.add(totalLabel);
        totalPanel.add(this.grandTotalField);
        totalPanel.add(floatLabel);
        totalPanel.add(this.floatField);
        totalPanel.add(totalLessFloatLabel);
        totalPanel.add(this.totalLessFloatField);
        return totalPanel;
    }

    @Override
    public void setCashdrawerReconciliation(CashdrawerReconciliation recon) {
        super.setCashdrawerReconciliation(recon);
        Denomination[] allDenoms = Denomination.getDenominations();
        this.getBindings().clear();
        AutoBinding floatBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)recon, (Property)BeanProperty.create((String)(CashdrawerReconciliation.Properties.FLOAT_ENTRY.getName() + "." + FloatEntry.Properties.VALUE.getName())), (Object)this.floatField, (Property)BeanProperty.create((String)"text"));
        floatBinding.setConverter((Converter)new PriceToStringConverter(0.01));
        floatBinding.bind();
        this.getBindings().addBinding((Binding)floatBinding);
        final ArrayList<ActualCashEntry> actualCashEntries = new ArrayList<ActualCashEntry>();
        AbstractBindingListener listener = new AbstractBindingListener((Binding)floatBinding){
            final /* synthetic */ Binding val$floatBinding;
            {
                this.val$floatBinding = binding;
            }

            public void synced(Binding arg0) {
                Price total = new Price(0.0, 0.01);
                Iterator it = actualCashEntries.iterator();
                while (it.hasNext()) {
                    total = total.add(((ActualCashEntry)it.next()).getValue());
                }
                ActualCashEntryEditor.this.grandTotalField.setText(total.toString());
                this.val$floatBinding.refresh();
                ActualCashEntryEditor.this.totalLessFloatField.setText(total.subtract((Price)this.val$floatBinding.getTargetValueForSource().getValue()).toString());
            }
        };
        for (int i = 0; i < allDenoms.length; ++i) {
            ActualCashEntry currentEntry = recon.getActualCashEntry(allDenoms[i]);
            actualCashEntries.add(currentEntry);
            AutoBinding newBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)currentEntry, (Property)BeanProperty.create((String)ActualCashEntry.Properties.VALUE.getName()), this.denominationTextFields.get(allDenoms[i]), (Property)BeanProperty.create((String)"text"));
            newBinding.setConverter((Converter)new PriceToStringConverter(0.01));
            newBinding.setValidator((Validator)new DenominationValidator(allDenoms[i]));
            newBinding.addBindingListener((BindingListener)listener);
            newBinding.bind();
            this.getBindings().addBinding((Binding)newBinding);
        }
    }

    @Override
    protected PropertiedObject.Property getKeyProperty() {
        return CashdrawerReconciliation.Properties.ACTUAL_CASH_TOTAL;
    }

    private JPanel getEntryField(Denomination denom) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JTextField field = new JTextField(10);
        field.setName(denom.getLabel());
        JLabel label = new JLabel("Total " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
        JTextField totalField = new JTextField(10);
        totalField.setName(denom.getLabel() + "_total");
        label.setLabelFor(totalField);
        panel.add(field);
        panel.add(label);
        panel.add(totalField);
        this.denominationTextFields.put(denom, totalField);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)field, (Property)BeanProperty.create((String)"text"), (Object)totalField, (Property)BeanProperty.create((String)"text"));
        binding.setConverter((Converter)new TotalToUnitDenominationConverter(denom));
        binding.bind();
        return panel;
    }
}

