/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.reconciliation.entryeditor;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ordermate.database.finance.Denomination;

public class DenominationEditingPanel
extends JPanel {
    private Map<Denomination, EntryHolder> fieldMap = new HashMap<Denomination, EntryHolder>();
    private JLabel totalLabel;

    public DenominationEditingPanel(List<Denomination> denominations) {
        super((LayoutManager)new GraphPaperLayout(7, denominations.size() * 3 + 4));
        int count = 0;
        for (Denomination den : denominations) {
            this.makePanelFor(den, count);
            ++count;
        }
        this.totalLabel = new JLabel("Total: $0.00");
        this.totalLabel.setFont(this.totalLabel.getFont().deriveFont(1));
        this.add((Component)this.totalLabel, new Rectangle(5, 1 + count * 3, 2, 2));
    }

    private void makePanelFor(final Denomination den, int count) {
        final EntryHolder holder = new EntryHolder();
        holder.label = new JLabel(den.getLabel());
        holder.total = new JLabel("$0.00");
        holder.totalLabel = new JLabel("Total");
        holder.total.setForeground(Color.GRAY);
        holder.totalLabel.setForeground(Color.GRAY);
        holder.entry = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        holder.entry.setName(den.getLabel() + "_spinner");
        holder.entry.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Number value = (Number)holder.entry.getValue();
                if (value == null) {
                    value = 0;
                }
                holder.totalLabel.setForeground(value.intValue() == 0 ? Color.GRAY : Color.BLACK);
                holder.total.setForeground(value.intValue() == 0 ? Color.GRAY : Color.BLACK);
                holder.total.setText(new Price(den.getValue() * (double)value.intValue(), 0.01).toString());
                DenominationEditingPanel.this.updateTotal();
            }
        });
        int y = 1 + count * 3;
        this.add((Component)holder.label, new Rectangle(1, y, 1, 2));
        this.add((Component)holder.entry, new Rectangle(2, y, 2, 2));
        this.add((Component)holder.totalLabel, new Rectangle(5, y, 1, 2));
        this.add((Component)holder.total, new Rectangle(6, y, 1, 2));
        this.fieldMap.put(den, holder);
    }

    public void setDenominationCount(Denomination denomination, int unitCount) {
        EntryHolder holder = this.fieldMap.get(denomination);
        if (holder == null) {
            throw new IllegalStateException("Cannot set denomination if not defined in the constructor");
        }
        holder.entry.setValue(unitCount);
    }

    public int getDenominationCount(Denomination denomination) {
        EntryHolder holder = this.fieldMap.get(denomination);
        if (holder == null) {
            throw new IllegalStateException("Cannot set denomination if not defined in the constructor");
        }
        return this.getAmount(holder);
    }

    private int getAmount(EntryHolder holder) {
        Number result = (Number)holder.entry.getValue();
        return result != null ? result.intValue() : 0;
    }

    private void updateTotal() {
        double value = 0.0;
        for (Denomination denom : this.fieldMap.keySet()) {
            value += denom.getValue() * (double)this.getAmount(this.fieldMap.get(denom));
        }
        this.totalLabel.setText("Total: " + new Price(value, 0.01));
    }

    public void setEditable(boolean canEdit) {
        for (EntryHolder holder : this.fieldMap.values()) {
            holder.entry.setEnabled(canEdit);
        }
    }

    class EntryHolder {
        JLabel label;
        JLabel total;
        JLabel totalLabel;
        JSpinner entry;

        EntryHolder() {
        }
    }
}

