/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.reconciliation.entryeditor;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import officemate.screens.reports.reconciliation.entryeditor.AbstractEntryEditor;
import officemate.screens.reports.reconciliation.entryeditor.ActualCashEntryEditor;
import officemate.screens.reports.reconciliation.entryeditor.CreditEntryEditor;
import officemate.screens.reports.reconciliation.entryeditor.OverringEditor;
import officemate.screens.reports.reconciliation.entryeditor.PettyCashEntryEditor;
import officemate.screens.reports.reconciliation.entryeditor.SimpleEntryEditor;
import officemate.screens.reports.reconciliation.entryeditor.SkimsEditor;
import officemate.screens.reports.reconciliation.entryeditor.TipsEntryEditor;
import officemate.screens.reports.reconciliation.entryeditor.WebEntryEditor;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;

public class EntryEditorPanelVendor {
    private static final EntryEditorPanelVendor instance = new EntryEditorPanelVendor();
    private Map<PropertiedObject.Property, AbstractEntryEditor> editorMap = new HashMap<PropertiedObject.Property, AbstractEntryEditor>();

    public static EntryEditorPanelVendor getInstance() {
        return instance;
    }

    private EntryEditorPanelVendor() {
        this.register(new SimpleEntryEditor("Float :", CashdrawerReconciliation.Properties.FLOAT_ENTRY));
        this.register(new OverringEditor());
        this.register(new ActualCashEntryEditor());
        this.register(new SkimsEditor());
        this.register(new SimpleEntryEditor("Cash Out :", CashdrawerReconciliation.Properties.CASH_OUT_ENTRY));
        this.register(new SimpleEntryEditor("Tips : ", CashdrawerReconciliation.Properties.TIPS_ENTRIES));
        this.register(new CreditEntryEditor());
        this.register(new WebEntryEditor());
        this.register(new PettyCashEntryEditor());
        this.register(new TipsEntryEditor());
    }

    private void register(AbstractEntryEditor editor) {
        this.editorMap.put(editor.getKeyProperty(), editor);
    }

    public AbstractEntryEditor getEditor(PropertiedObject.Property property) {
        if (!property.getOwner().equals(CashdrawerReconciliation.class)) {
            throw new IllegalArgumentException("Property :" + property + " should belong to CashDrawerReconciliation but instead belongs to: " + property.getOwner());
        }
        AbstractEntryEditor editor = this.editorMap.get(property);
        if (!Config.getBooleanValue((String)"debug") || editor == null) {
            // empty if block
        }
        return editor;
    }

    public Collection getRegisteredProperties() {
        return this.editorMap.keySet();
    }
}

