/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.reconciliation.entryeditor;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OkCancelDialogBuilder;
import officemate.screens.reports.reconciliation.entryeditor.AbstractEntryEditor;
import officemate.screens.reports.reconciliation.entryeditor.DenominationEditingPanel;
import officemate.screens.reports.reconciliation.skims.SkimsTransactionTable;
import ordermate.database.finance.Denomination;
import ordermate.database.finance.Shift;
import ordermate.database.finance.Skim;
import ordermate.database.finance.SkimTransaction;
import ordermate.database.finance.SkimTransactionEntry;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.modify.security.StandardSecurityDecorator;

public class SkimsEditor
extends AbstractEntryEditor
implements ActionListener {
    private SkimsTransactionTable txnTable;
    private JButton newSkim;
    private JButton deleteSkim;
    private Set<Skim> skims = new LinkedHashSet<Skim>();

    public SkimsEditor() {
        this.setupComponents();
    }

    private void setupComponents() {
        JPanel holder = new JPanel(new BorderLayout());
        JPanel buttonHolder = new JPanel(new FlowLayout(0));
        this.newSkim = new JButton("New Skim", IconLoader.get((String)"/ordermate/images/new_icon22.png"));
        this.deleteSkim = new JButton("Delete Skim", IconLoader.get((String)"/ordermate/images/delete_icon22.png"));
        this.newSkim.addActionListener(this);
        this.deleteSkim.addActionListener(this);
        StandardSecurityDecorator newSkimSecurity = new StandardSecurityDecorator((JComponent)this.newSkim, AllPermissions.SKIMS);
        StandardSecurityDecorator deleteSkimSecurity = new StandardSecurityDecorator((JComponent)this.deleteSkim, AllPermissions.SKIMS);
        buttonHolder.add((Component)newSkimSecurity);
        buttonHolder.add((Component)deleteSkimSecurity);
        this.txnTable = new SkimsTransactionTable();
        this.txnTable.objectDoubleClicked().connect((Object)this, "gotTransactionSelected");
        this.txnTable.setPreferredSize(new Dimension(500, 300));
        holder.add((Component)buttonHolder, "North");
        holder.add((Component)this.txnTable, "Center");
        this.add(holder);
    }

    @Override
    protected PropertiedObject.Property getKeyProperty() {
        return CashdrawerReconciliation.Properties.TOTAL_SKIMS;
    }

    @Override
    public void setCashdrawerReconciliation(CashdrawerReconciliation reconciliation) {
        super.setCashdrawerReconciliation(reconciliation);
        this.skims.clear();
        this.skims.addAll(Skim.getSkims((Shift)reconciliation.getParent().getShift(), (CashDrawer)reconciliation.getCashDrawer()));
        this.refreshTable();
    }

    private void refreshTable() {
        ArrayList<SkimTransaction> txns = new ArrayList<SkimTransaction>();
        for (Skim skim : this.skims) {
            txns.addAll(skim.getActiveTransactions());
        }
        this.txnTable.setSkimTransactions(txns);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.newSkim && this.newSkim.isEnabled()) {
            this.newSkimTxn();
        } else if (e.getSource() == this.deleteSkim && this.deleteSkim.isEnabled()) {
            this.deleteSkimTxn();
        }
    }

    public void gotTransactionSelected() {
        SkimTransaction txn = (SkimTransaction)this.txnTable.getSelectedObject();
        if (txn != null && FinanceUnit.getDefaultUnitFor((FinanceUnit.FinanceUnitType)FinanceUnit.CASH_TYPE).equals((Object)txn.getFinanceUnit())) {
            this.editTransaction(txn, this.canModify(txn));
        }
    }

    private boolean canModify(SkimTransaction txn) {
        return !txn.isPersistent() || GuiApp.getAppComplex().getApplicationSecurity().getUser().hasPermission(AllPermissions.EDIT_SKIMS);
    }

    private void newSkimTxn() {
        FinanceUnit cashUnit = FinanceUnit.getDefaultUnitFor((FinanceUnit.FinanceUnitType)FinanceUnit.CASH_TYPE);
        CashdrawerReconciliation rec = this.getCashDrawerReconciliation();
        Skim skim = new Skim(OfficeMate.getInstance().getEventContext().getUser(), rec.getParent().getShift(), rec.getCashDrawer());
        SkimTransaction txn = skim.addTransaction(Price.ZERO_DOLLAR, cashUnit);
        this.skims.add(skim);
        if (!this.editTransaction(txn, true)) {
            this.skims.remove(skim);
            skim.removeTransaction(txn);
        }
        this.refreshTable();
    }

    private void deleteSkimTxn() {
        SkimTransaction txn = (SkimTransaction)this.txnTable.getSelectedObject();
        if (txn != null) {
            if (this.canModify(txn)) {
                if (Dialogs.showWarningDialog("Confirm Delete Skim Entry", "This will permanently delete the skim entry. Are you sure?")) {
                    txn.deleteChild();
                    this.skims.remove(txn.getSkim());
                    TerminalEventLog.logCashDrawerSkim((User)GuiApp.getAppComplex().getApplicationSecurity().getUser(), (Terminal)Terminal.getServerMateTerminal(), (Skim)txn.getSkim());
                    this.refreshTable();
                }
            } else {
                Dialogs.showWarningDialog("Cannot Delete", "You do not have permission to delete this skim.");
            }
        }
    }

    private boolean editTransaction(SkimTransaction txn, boolean canEdit) {
        List<Denomination> denominations = Arrays.asList(Denomination.getDenominations());
        DenominationEditingPanel panel = new DenominationEditingPanel(denominations);
        for (SkimTransactionEntry entry : txn.getEntries()) {
            panel.setDenominationCount(entry.getDenomination(), entry.getUnitCount());
        }
        OkCancelDialogBuilder builder = Dialogs.getOkCancelDialogBuilder(panel);
        builder.setTitle("Edit Skim for " + txn.getSkim().getCreationTimeAsString());
        panel.setEditable(canEdit);
        if (builder.doShow() && canEdit) {
            for (Denomination den : denominations) {
                int count = panel.getDenominationCount(den);
                txn.setEntry(den, count);
            }
            TerminalEventLog.logCashDrawerSkim((User)GuiApp.getAppComplex().getApplicationSecurity().getUser(), (Terminal)Terminal.getServerMateTerminal(), (Skim)txn.getSkim());
            return true;
        }
        return false;
    }

    @Override
    public void save() {
        for (Skim skim : this.skims) {
            skim.save();
        }
    }
}

