/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.reconciliation.report;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import officemate.screens.reports.jasper.JasperReportState;
import officemate.screens.reports.jasper.JasperToolbarFactory;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.reports.reconciliation.ReconciliationReportCompiler;
import ordermate.database.reports.reconciliation.ReconciliationReportProvider;
import ordermate.database.users.AllPermissions;
import ordermate.gui.FieldPanelBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;

public class ReconciliationReportState
extends JasperReportState
implements ActionListener {
    private EventList<ShiftReconciliation> recList;
    private JComboBox recCombo;
    private JCheckBox summaryCheck;
    private final ReconciliationReportCompiler compiler = ((ReconciliationReportProvider)this.getProvider()).getCompiler();

    public ReconciliationReportState() {
        super((ReportProvider)new ReconciliationReportProvider(new ReconciliationReportCompiler()), "Reconciliation Report", AllPermissions.ACCESS_SALES_REPORT, "View a Reconciliation summary or detail report");
    }

    @Override
    protected JasperToolbarFactory createJasperToolbarFactory() {
        return new JasperToolbarFactory(){

            @Override
            protected JPanel getCustomReportControlPanel() {
                return ReconciliationReportState.this.createCustomReportControlPanel();
            }
        };
    }

    private JPanel createCustomReportControlPanel() {
        FieldPanelBuilder builder = new FieldPanelBuilder(5);
        this.recList = new BasicEventList();
        this.recCombo = new JComboBox(new EventComboBoxModel(this.recList));
        this.recCombo.addActionListener(this);
        builder.addRow("Reconciliation", (Component)this.recCombo);
        ComponentUtils.setupComboBox((JComboBox)this.recCombo);
        this.summaryCheck = new JCheckBox("Summary");
        this.summaryCheck.setSelected(true);
        this.summaryCheck.addActionListener(this);
        builder.addRow("Summary", (Component)this.summaryCheck);
        return builder.getPanel();
    }

    @Override
    public void onStart() {
        super.onStart();
        if (this.recList != null) {
            this.recList.getReadWriteLock().writeLock().lock();
            this.recList.clear();
            this.recList.addAll((Collection)PersistenceManager.getObjectList(ShiftReconciliation.class, (String)Query.select(ShiftReconciliation.class).orderBy(ShiftReconciliation.Properties.SHIFT, true).toString()));
            this.recList.getReadWriteLock().writeLock().unlock();
            this.recCombo.setSelectedItem(this.recList.get(0));
        }
    }

    @Override
    public void onEnd() {
        if (this.recList != null) {
            this.recList.getReadWriteLock().writeLock().lock();
            this.recList.clear();
            this.recList.getReadWriteLock().writeLock().unlock();
        }
        super.onEnd();
    }

    @Override
    public void refresh() {
        if (this.compiler != null) {
            this.compiler.setSummary(this.summaryCheck.isSelected());
            this.compiler.setReconciliation((ShiftReconciliation)this.recCombo.getSelectedItem());
        }
        if (this.recCombo.getSelectedItem() != null) {
            super.refresh();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.refresh();
    }
}

