/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.reconciliation.skims;

import ca.odell.glazedlists.BasicEventList;
import java.text.DateFormat;
import java.util.List;
import officemate.components.table.PersistentObjectTable;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.PropertyAccessorColumnFormat;
import ordermate.database.finance.Shift;
import ordermate.database.finance.Skim;
import ordermate.database.finance.SkimTransaction;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class SkimsTransactionTable
extends PersistentObjectTable<SkimTransaction> {
    public SkimsTransactionTable() {
        super(new BasicEventList(), new SkimsColumnFormat());
    }

    public void setSkimTransactions(List<SkimTransaction> txns) {
        this.getEventList().clear();
        if (txns != null) {
            this.getEventList().addAll(txns);
        }
        this.getTable().packAll();
        this.getTable().validate();
        this.getTable().repaint();
    }

    public void setShift(Shift theShift) {
        this.setSkimTransactions(theShift == null ? null : SkimTransaction.getSkimTransactions((Shift)theShift));
    }

    private static class SkimsColumnFormat
    extends ColumnTableFormat {
        public SkimsColumnFormat() {
            super(new ColumnFormat[]{new PropertyAccessorColumnFormat("Time", SkimTransaction.Properties.SKIM, Skim.Properties.CREATION_TIME, DateFormat.getTimeInstance(3)), new PropertyAccessorColumnFormat("Drawer", SkimTransaction.Properties.SKIM, Skim.Properties.CASH_DRAWER), new PropertyAccessorColumnFormat(SkimTransaction.Properties.SKIM, Skim.Properties.USER), new PropertyColumnFormat("Unit", SkimTransaction.Properties.FINANCE_UNIT), new PropertyColumnFormat(SkimTransaction.Properties.AMOUNT)});
        }
    }
}

