/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.salesbyarea;

import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import javax.swing.table.AbstractTableModel;
import officemate.adminkit.table.PriceGroupedTableModel;
import ordermate.database.queries.stock.StockAreaQueries;

public class SalesByAreaGroupedTableModel
extends PriceGroupedTableModel {
    private double cogs;
    private double sales;
    private final int IND_COL_SALES = 1;
    private final int IND_COL_SALES_EX_GST = 2;

    public SalesByAreaGroupedTableModel(AbstractTableModel wrappedModel, String groupedCol, String[] totalledCols) {
        super(wrappedModel, groupedCol, totalledCols);
    }

    @Override
    protected Object createTotalValue(Object group, double value, int row, int col) {
        String colName = this.getColumnName(col);
        if (colName.equals("Est. Cost")) {
            this.cogs = value;
        }
        if (colName.equals(StockAreaQueries.DISPLAYLABEL_SALES_EX)) {
            this.sales = value;
        }
        if (colName.equals("GP %")) {
            double gpPercent = 0.0;
            if (!MathsUtils.approxEquals((double)0.0, (double)this.sales)) {
                gpPercent = (this.sales - this.cogs) / this.sales;
            }
            return new Double(MathsUtils.roundDoubleToDecPlaces((double)gpPercent, (int)2));
        }
        return super.createTotalValue(group, value, row, col);
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row == this.getRowCount() - 1 && (col == 1 || col == 2)) {
            Price price = (Price)super.getValueAt(row, col);
            Double percentDiscount = (Double)super.getValueAt(row - 2, col);
            Double percentSurcharge = (Double)super.getValueAt(row - 1, col);
            return price.subtract(new Price((Number)percentDiscount, 0.01)).subtract(new Price((Number)percentSurcharge, 0.01));
        }
        return super.getValueAt(row, col);
    }
}

