/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.salesbyarea;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.guicore.task.AbstractGuiTask;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.util.DateDMY_HM;
import au.com.ordermate.util.FormatStringifier;
import au.com.ordermate.util.Stringifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import officemate.adminkit.DateRangePanel;
import officemate.adminkit.DateTimeRangePanel;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.print.Printing;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.table.GroupedTable;
import officemate.adminkit.table.ShadeAlternateRowsTableCellRenderer;
import officemate.screens.reports.salesbyarea.SalesByAreaGroupedTableModel;
import officemate.screens.reports.salesbyarea.SalesByAreaTable;
import ordermate.database.queries.stock.StockAreaQueries;
import ordermate.database.reports.sales.byarea.SalesByAreaSearcher;
import ordermate.database.users.AllPermissions;

public class SalesByAreaReportState
extends BasicOfficeMateState {
    private JPanel innerPanel;
    private JPanel northPanel;
    private JPanel northWestPanel;
    private JPanel tablePanel;
    private JPanel eastPanel;
    private DateTimeRangePanel dateTimePanel = null;
    private DateRangePanel datePanel = null;
    private GroupedTable groupedTable;
    private JCheckBox groupedCheck;
    private boolean groupResults = true;
    private JCheckBox tradingDayCheck;
    private boolean entireTradingDay = false;
    private SalesByAreaTable table;
    private SalesByAreaSearcher searcher;
    private boolean alreadySetup = false;
    private long lastRefresh = System.currentTimeMillis();
    private static final long MIN_REFRESH_INTERVAL = 5000L;

    public SalesByAreaReportState() {
        super("Sales By Area", AllPermissions.ACCESS_SALES_BY_AREA_REPORT, "Show sales by area, over a time period");
        this.searcher = new SalesByAreaSearcher();
        this.innerPanel = new JPanel(new BorderLayout());
        this.setScreenPanel(this.innerPanel);
    }

    @Override
    protected void onStart() {
        GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Loading Sales By Area Report screen...");
        if (!this.alreadySetup) {
            this.alreadySetup = Dialogs.showProgressDialog((AbstractTask)new SalesByAreaSetupTask());
            if (!this.alreadySetup) {
                Dialogs.showErrorDialog("Error Loading Screen", "Please contact OrderMate Support");
                return;
            }
        } else {
            this.refresh();
        }
        GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
    }

    @Override
    protected void onEnd() {
    }

    private void setupGUI() {
        this.eastPanel = new JPanel(new BorderLayout());
        this.northPanel = new JPanel(new BorderLayout());
        this.northWestPanel = new JPanel(new FlowLayout());
        this.tablePanel = new JPanel(new BorderLayout());
        JPanel addRemoveWrapper = new JPanel(new BorderLayout());
        this.eastPanel.add((Component)this.tablePanel, "Center");
        this.eastPanel.add((Component)addRemoveWrapper, "East");
        this.innerPanel.add((Component)this.eastPanel, "Center");
        this.northPanel.add((Component)this.northWestPanel, "West");
        this.innerPanel.add((Component)this.northPanel, "North");
    }

    private void setupDates() {
        this.dateTimePanel = new DateTimeRangePanel();
        this.dateTimePanel.datesChanged.connect((Object)this, "gotDatesChanged");
        this.dateTimePanel.setStartDate((Date)this.searcher.getDateRangeFilter().getStart());
        this.dateTimePanel.setEndDate((Date)this.searcher.getDateRangeFilter().getEnd());
        this.datePanel = new DateRangePanel();
        this.datePanel.setUsesTradingDayBoundaries(true);
        this.datePanel.datesChanged.connect((Object)this, "gotDatesChanged");
        this.datePanel.setStartDate((Date)this.searcher.getDateRangeFilter().getStart());
        this.datePanel.setEndDate((Date)this.searcher.getDateRangeFilter().getEnd());
        if (!this.entireTradingDay) {
            this.northPanel.add((Component)this.dateTimePanel, "East");
        } else {
            this.northPanel.add((Component)this.datePanel, "East");
        }
    }

    private void setupGroupCheck() {
        this.groupedCheck = new JCheckBox("Group results", this.groupResults);
        this.northWestPanel.add(this.groupedCheck);
        this.groupedCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SalesByAreaReportState.this.groupResults = SalesByAreaReportState.this.groupedCheck.isSelected();
                SalesByAreaReportState.this.updateQuery();
            }
        });
    }

    private void setupTradingDayCheck() {
        this.tradingDayCheck = new JCheckBox("Entire trading day", this.entireTradingDay);
        this.northWestPanel.add(this.tradingDayCheck);
        this.tradingDayCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SalesByAreaReportState.this.entireTradingDay = SalesByAreaReportState.this.tradingDayCheck.isSelected();
                if (!SalesByAreaReportState.this.entireTradingDay) {
                    SalesByAreaReportState.this.northPanel.remove(SalesByAreaReportState.this.datePanel);
                    SalesByAreaReportState.this.northPanel.add((Component)SalesByAreaReportState.this.dateTimePanel, "East");
                    SalesByAreaReportState.this.searcher.getDateRangeFilter().setStart((Comparable)SalesByAreaReportState.this.dateTimePanel.getStartDate());
                    SalesByAreaReportState.this.searcher.getDateRangeFilter().setEnd((Comparable)SalesByAreaReportState.this.dateTimePanel.getEndDate());
                } else {
                    SalesByAreaReportState.this.northPanel.remove(SalesByAreaReportState.this.dateTimePanel);
                    SalesByAreaReportState.this.northPanel.add((Component)SalesByAreaReportState.this.datePanel, "East");
                    SalesByAreaReportState.this.searcher.getDateRangeFilter().setStart((Comparable)SalesByAreaReportState.this.datePanel.getStartDate());
                    SalesByAreaReportState.this.searcher.getDateRangeFilter().setEnd((Comparable)SalesByAreaReportState.this.datePanel.getEndDate());
                }
                SalesByAreaReportState.this.updateQuery();
            }
        });
    }

    private void setupTable() {
        this.table = new SalesByAreaTable(this.searcher);
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup(this.table);
        this.tablePanel.add((Component)this.table.getScroller(), "Center");
    }

    private GroupedTable getNewGroupedTable() {
        SalesByAreaGroupedTableModel model = new SalesByAreaGroupedTableModel((AbstractTableModel)this.table.getModel(), "Stock Area", new String[]{"Sales", StockAreaQueries.DISPLAYLABEL_SALES_EX, "Est. Cost", "GP", "GP %"});
        this.groupedTable = new GroupedTable(model);
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup((JTable)((Object)this.groupedTable));
        ShadeAlternateRowsTableCellRenderer renderer = new ShadeAlternateRowsTableCellRenderer();
        renderer.setStringifier((Stringifier)new FormatStringifier((Format)NumberFormat.getCurrencyInstance(), Double.class));
        this.groupedTable.setDefaultRenderer(Double.class, renderer);
        this.groupedTable.getColumn("Sales").setCellRenderer(renderer);
        this.groupedTable.getColumn(StockAreaQueries.DISPLAYLABEL_SALES_EX).setCellRenderer(renderer);
        this.groupedTable.getColumn("Est. Cost").setCellRenderer(renderer);
        this.groupedTable.getColumn("GP").setCellRenderer(renderer);
        NumberFormat percentageFormatter = NumberFormat.getPercentInstance();
        percentageFormatter.setMinimumFractionDigits(1);
        percentageFormatter.setMaximumFractionDigits(2);
        renderer = new ShadeAlternateRowsTableCellRenderer();
        renderer.setStringifier((Stringifier)new FormatStringifier((Format)percentageFormatter, Double.class));
        this.groupedTable.getColumn("GP %").setCellRenderer(renderer);
        return this.groupedTable;
    }

    public void updateQuery() {
        if (this.table == null) {
            return;
        }
        Dialogs.createProgressDialog((AbstractTask)new AbstractGuiTask(){

            protected void doGuiTask() throws Exception {
                SalesByAreaReportState.this.table.updateSearch();
                SalesByAreaReportState.this.table.revalidate();
                SalesByAreaReportState.this.tablePanel.remove(SalesByAreaReportState.this.table.getScroller());
                if (SalesByAreaReportState.this.groupedTable != null) {
                    SalesByAreaReportState.this.tablePanel.remove(SalesByAreaReportState.this.groupedTable.getScroller());
                }
                if (SalesByAreaReportState.this.groupResults) {
                    SalesByAreaReportState.this.tablePanel.add((Component)SalesByAreaReportState.this.getNewGroupedTable().getScroller(), "Center");
                } else {
                    SalesByAreaReportState.this.tablePanel.add((Component)SalesByAreaReportState.this.table.getScroller(), "Center");
                }
                SalesByAreaReportState.this.innerPanel.revalidate();
                SalesByAreaReportState.this.innerPanel.repaint();
                SalesByAreaReportState.this.lastRefresh = System.currentTimeMillis();
            }

            public String getName() {
                return "Preparing report...";
            }

            protected int getTotalSubTasks() {
                return 0;
            }
        }).start();
    }

    @Override
    public boolean supportsRefresh() {
        return true;
    }

    @Override
    public boolean supportsPrint() {
        return true;
    }

    @Override
    public void doRefreshAction() {
        this.refresh();
    }

    @Override
    public void refresh() {
        if (System.currentTimeMillis() >= this.lastRefresh + 5000L) {
            this.updateQuery();
        }
    }

    void gotDatesChanged(Date newStartDate, Date newEndDate) {
        this.searcher.getDateRangeFilter().setStart((Comparable)newStartDate);
        this.searcher.getDateRangeFilter().setEnd((Comparable)newEndDate);
        this.updateQuery();
    }

    public JTable getActiveTable() {
        return this.groupResults ? this.groupedTable : this.table;
    }

    @Override
    @Deprecated
    public void doPrintAction() {
        DateDMY_HM date1 = new DateDMY_HM((Date)this.searcher.getDateRangeFilter().getStart());
        DateDMY_HM date2 = new DateDMY_HM((Date)this.searcher.getDateRangeFilter().getEnd());
        String title = "Sales by Area (from " + date1 + " to " + date2 + ")";
        Printing.printJTableReport(this.getActiveTable(), title, "", 8, null);
    }

    public SalesByAreaSearcher getSearcher() {
        return this.searcher;
    }

    private class SalesByAreaSetupTask
    extends AbstractGuiTask {
        private SalesByAreaSetupTask() {
        }

        public String getName() {
            return "Loading Sales By Area Report screen...";
        }

        public void doGuiTask() throws Exception {
            SalesByAreaReportState.this.setupGUI();
            this.emitProgress();
            SalesByAreaReportState.this.setupGroupCheck();
            this.emitProgress();
            SalesByAreaReportState.this.setupTradingDayCheck();
            this.emitProgress();
            SalesByAreaReportState.this.setupDates();
            this.emitProgress();
            SalesByAreaReportState.this.setupTable();
            this.emitProgress();
        }

        public int getTotalSubTasks() {
            return 5;
        }
    }
}

