/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.saleshistory;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.SingleValueQuerySearchFilter;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.Format;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JCheckBox;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.state.SearchGuiState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.search.objectsearch.CustomerSearcherGui;
import officemate.components.search.searchfield.ObjectSearchField;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.reports.saleshistory.ComboDateRangeSearchField;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.ConfigShift;
import ordermate.database.reports.sales.time.SalesHistoryReport;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.searchers.reports.sales.time.SalesHistoryReportSearcher;
import ordermate.database.users.AllPermissions;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class SalesHistoryReportSearchState
extends AbstractTableState<SalesHistoryReport>
implements SearchGuiState<SalesHistoryReport> {
    private SalesHistoryReportSearcher searcher;
    private RefreshAction refreshAction = new RefreshAction((Refreshable)this);
    private EventList allCustomerCategories = GlazedLists.eventList((Collection)CustomerCategory.getAllCategories());
    private EventList<ConfigShift> shiftsList = GlazedLists.eventList((Collection)ConfigShift.getAllConfigShifts());
    private JCheckBox includeEmptyDates;

    public SalesHistoryReportSearchState(SalesHistoryReportSearcher searcher) {
        super("Search", AllPermissions.ACCESS_SALES_REPORT, "Find sales to report on.");
        this.searcher = searcher;
    }

    @Override
    protected TableStateCentralArea<SalesHistoryReport> createCentralArea() {
        DateFormat dateFormat = this.searcher.getPeriod().getFormatter();
        return new PersistentObjectTable<SalesHistoryReport>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(this.searcher.getPeriod().getLabel(), (PropertyAccessor)SalesHistoryReport.Properties.PERIOD_START_DATE, (Format)dateFormat), new PropertyColumnFormat(SalesHistoryReport.Properties.SALES_VALUE)}));
    }

    @Override
    protected Class<SalesHistoryReport> getDisplayingType() {
        return SalesHistoryReport.class;
    }

    @Override
    public ObjectQuerySearcher<SalesHistoryReport> getSearcher() {
        return this.searcher;
    }

    @Override
    protected OfficeMateObjectSearch<SalesHistoryReport> createSearchPanelFactory() {
        ObjectPropertySearch<SalesHistoryReport> search = new ObjectPropertySearch<SalesHistoryReport>(SalesHistoryReport.class, (ObjectQuerySearcher)this.searcher, (EventList)new BasicEventList()){

            @Override
            public void reaquireSearchOptions() {
                super.reaquireSearchOptions();
                OfficeMateAdminGuiUtils.getInstance().refreshList(SalesHistoryReportSearchState.this.allCustomerCategories, CustomerCategory.getAllCategories());
                OfficeMateAdminGuiUtils.getInstance().refreshList(SalesHistoryReportSearchState.this.shiftsList, ConfigShift.getAllConfigShifts());
            }
        };
        search.useSearchRefreshStrategy();
        PeriodReportAdapter period = this.searcher.getPeriod();
        if (period == null || period == PeriodReportAdapter.DAILY) {
            search.addSearchField((SearchGuiField)new DateRangeSearchField("Dates", this.searcher.getTradingDayDateRangeFilter(), Calendar.getInstance().getTime(), (Action)this.refreshAction));
        } else {
            search.addSearchField(new ComboDateRangeSearchField((IRangedQuerySearchFilter<Date>)this.searcher.getTradingDayDateRangeFilter(), period, this.refreshAction));
        }
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Shift", (Action)this.refreshAction, this.shiftsList, null, this.searcher.getShiftFilter(), new JCheckBoxCellRenderer()));
        search.addSearchField(new ObjectSearchField((SingleValueQuerySearchFilter)this.searcher.getCustomerFilter(), new CustomerSearcherGui(this.allCustomerCategories), CustomerSearcherGui.DEFAULT_TABLE_FORMAT, "Customer", (Action)this.refreshAction, true));
        search.addSearchField((SearchGuiField)new ComboSearchField("Customer Category", this.searcher.getCustomerTypeFilter(), true, (Action)this.refreshAction, this.allCustomerCategories));
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Sales Location", this.searcher.getSalesLocationFilter(), (Action)this.refreshAction, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations())));
        this.includeEmptyDates = new JCheckBox("Include Empty Dates: ");
        this.includeEmptyDates.setHorizontalTextPosition(2);
        this.includeEmptyDates.setSelected(true);
        this.includeEmptyDates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SalesHistoryReportSearchState.this.searcher.setIncludeEmptyDates(SalesHistoryReportSearchState.this.includeEmptyDates.isSelected());
                SalesHistoryReportSearchState.this.refreshAction.doRefresh();
            }
        });
        search.getSearchPanel().add((Component)this.includeEmptyDates, "East");
        return search;
    }
}

