/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.saleshistory.substates;

import ar.com.fdvs.dj.domain.builders.BuilderException;
import au.com.ordermate.util.OffsetFunction;
import java.text.Format;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.state.CompositeGuiState;
import officemate.screens.reports.jasper.JasperReportState;
import officemate.screens.reports.saleshistory.SalesHistoryReportSearchState;
import ordermate.database.reports.saleshistory.SalesHistoryReportProvider;
import ordermate.database.searchers.reports.sales.time.SalesHistoryReportSearcher;
import ordermate.database.users.AllPermissions;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;

public abstract class AbstractSalesHistoryReportCompositeState
extends CompositeGuiState {
    private PeriodReportAdapter period;
    private final SalesHistoryReportSearcher searcher;
    private SalesHistoryReportProvider provider;

    public AbstractSalesHistoryReportCompositeState(PeriodReportAdapter period) throws BuilderException {
        super("Sales History by " + period.getUnitOfTime(), AllPermissions.ACCESS_SALES_REPORT, "Per " + period.getUnitOfTime() + " summary of sales");
        this.period = period;
        this.searcher = new SalesHistoryReportSearcher(period);
        this.addTabbedSubState(this.getSearchState(this.searcher));
        this.addTabbedSubState(this.getReportState(this.searcher));
    }

    private BasicOfficeMateState getSearchState(SalesHistoryReportSearcher searcher) {
        return new SalesHistoryReportSearchState(searcher);
    }

    private BasicOfficeMateState getReportState(SalesHistoryReportSearcher searcher) throws BuilderException {
        this.provider = new SalesHistoryReportProvider(searcher);
        return new JasperReportState((ReportProvider)this.provider, "Report", null, "Report for search selection.");
    }

    protected OffsetFunction getDateOffset() {
        return this.getPeriod().getDateOffset();
    }

    protected Format constructFormatter() {
        return this.getPeriod().getFormatter();
    }

    public PeriodReportAdapter getPeriod() {
        return this.period;
    }

    public SalesHistoryReportSearcher getSearcher() {
        return this.searcher;
    }

    @Override
    public void onStart() {
        if (this.getUser() != null && this.provider != null) {
            this.provider.setUser(this.getUser());
        }
        super.onStart();
    }
}

