/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.salestotakings;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.reports.RestaurantTakingsSummaryQueryHelper;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountSaveContext;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesComponentSaveContext;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;

public class SalesToTakingsAnomalyDetector {
    private static final int DISPLAY_LIMIT = 1500;
    private final TradingDay day;
    private final GuiHandler gui;

    public SalesToTakingsAnomalyDetector(TradingDay day, GuiHandler gui) {
        this.day = day;
        this.gui = gui;
    }

    public void start() {
        final List accounts = PersistenceManager.getObjectList(Account.class, (String)Query.select(Account.class).equals(Account.Properties.TRADING_DAY, (Object)this.day).toString());
        this.gui.displayOkDialog("Starting", "Will examine " + accounts.size() + " accounts...");
        this.gui.doProgressTask(new AbstractTask(){

            public String getName() {
                return "Detecting Anomalies";
            }

            protected void performTask() throws Exception {
                String invalidSaved = SalesToTakingsAnomalyDetector.this.detectIncorrectSavedTotals(accounts);
                this.emitProgress();
                String invalidClosed = SalesToTakingsAnomalyDetector.this.detectImbalance(accounts);
                this.emitProgress();
                String result = "Anomaly Results:" + System.lineSeparator() + invalidSaved + System.lineSeparator() + System.lineSeparator() + invalidClosed;
                List allAccountsWithFuturePayments = PersistenceManager.getObjectList(Account.class, (String)RestaurantTakingsSummaryQueryHelper.getAccountsWithFinanceTransactionsForFutureItemsQry((RestaurantTakingsSummaryQueryHelper.PeriodFilterBy)RestaurantTakingsSummaryQueryHelper.PeriodFilterBy.TRADING_DAY), (Object[])new Object[]{SalesToTakingsAnomalyDetector.this.day.getID(), SalesToTakingsAnomalyDetector.this.day.getID()});
                if (allAccountsWithFuturePayments != null && allAccountsWithFuturePayments.size() > 0) {
                    result = result + System.lineSeparator() + "the accounts that have finance transactions for items originally sold within a future period ";
                }
                for (Object account : allAccountsWithFuturePayments) {
                    result = result + System.lineSeparator() + account + System.lineSeparator();
                }
                List allAccountsWithPreviousSales = PersistenceManager.getObjectList(Account.class, (String)RestaurantTakingsSummaryQueryHelper.getAccountsPreviousSales((RestaurantTakingsSummaryQueryHelper.PeriodFilterBy)RestaurantTakingsSummaryQueryHelper.PeriodFilterBy.TRADING_DAY), (Object[])new Object[]{SalesToTakingsAnomalyDetector.this.day.getID(), SalesToTakingsAnomalyDetector.this.day.getID()});
                if (allAccountsWithPreviousSales != null && allAccountsWithPreviousSales.size() > 0) {
                    result = result + System.lineSeparator() + "the accounts that the total of all sales items in the current period but are linked to a previous period ";
                }
                for (Account account : allAccountsWithPreviousSales) {
                    result = result + System.lineSeparator() + account + System.lineSeparator();
                }
                List incorrectFinanceShiftAccounts = PersistenceManager.getObjectList(Account.class, (String)RestaurantTakingsSummaryQueryHelper.getAccountsWithIncorrectFinanceShift((RestaurantTakingsSummaryQueryHelper.PeriodFilterBy)RestaurantTakingsSummaryQueryHelper.PeriodFilterBy.TRADING_DAY), (Object[])new Object[]{SalesToTakingsAnomalyDetector.this.day.getID()});
                if (incorrectFinanceShiftAccounts != null && incorrectFinanceShiftAccounts.size() > 0) {
                    result = result + System.lineSeparator() + "the accounts that the shift of it does not match the trading day of it";
                    for (Account account : incorrectFinanceShiftAccounts) {
                        boolean fixed = SalesToTakingsAnomalyDetector.this.attemptFixAccountShift(account);
                        result = result + System.lineSeparator() + account + (fixed ? " FIXED" : "") + System.lineSeparator();
                    }
                }
                OrderMate.LOG.info(result);
                SalesToTakingsAnomalyDetector.this.gui.displayOkDialog("Results", result.length() > 1500 ? result.substring(0, 1500) + "... See Logs" : result);
            }

            protected int getTotalSubTasks() {
                return 2;
            }
        });
    }

    private boolean attemptFixAccountShift(Account acc) {
        try {
            SalesItemQuantity sq = (SalesItemQuantity)PersistenceManager.getObject(SalesItemQuantity.class, (String)Query.select(SalesItemQuantity.class).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).equals(SalesLineItem.Properties.ACCOUNT, (Object)acc).orderBy(SalesItemQuantity.Properties.SHIFT, false).toString());
            String sql = "UPDATE sales_account SET fk_finance_shift = ? WHERE id = ?";
            PersistenceManager.getPersistenceDelegate().executeUpdate(sql, new Object[]{sq.getShift().getID(), acc.getID()});
            acc = (Account)PersistenceManager.reacquire((PersistentObjectI)acc);
            return acc.getShift().getTradingDay().equals((Object)acc.getTradingDay());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Could not resolve the shift for acc " + acc.getID(), (Throwable)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String detectIncorrectSavedTotals(List<Account> accounts) {
        int detected = 0;
        int fixed = 0;
        ArrayList<Account> detectedAccountList = new ArrayList<Account>();
        ArrayList<Account> fixedAccountList = new ArrayList<Account>();
        for (Account account : accounts) {
            boolean anotherOne = false;
            for (SalesLineItem line : account.getAllItems()) {
                for (SalesItem item : line.getSalesItems()) {
                    boolean doSave = false;
                    for (SalesComponent comp : item.getComponentList()) {
                        Price savedPrice = comp.getSavedTotalPrice();
                        Price expected = comp.getTotalPrice();
                        doSave = doSave || !savedPrice.equals((Object)expected);
                    }
                    if (!doSave) continue;
                    anotherOne = true;
                    try {
                        item.saveChild();
                    }
                    catch (Exception ex) {
                        OrderMate.LOG.warn("Cannot save item for anomaly detection " + item.getID() + " from account " + account.getID(), (Throwable)ex);
                    }
                }
            }
            if (!account.getSavedTotal().approximatelyEquals(account.getTotal())) {
                anotherOne = true;
                if (account.lock(User.getSystemUser())) {
                    try {
                        AccountSaveContext context = new AccountSaveContext("Anomaly Fix", "NORMAL", Terminal.getServerMateTerminal(), User.getSystemUser());
                        account.prepareForSave((SaveContext)context);
                        account.save();
                        ++fixed;
                        fixedAccountList.add(account);
                    }
                    catch (Exception ex) {
                        OrderMate.LOG.warn("Could not fix anomaly in account:", (Throwable)ex);
                    }
                    finally {
                        account.unlock();
                    }
                } else {
                    OrderMate.LOG.warn("Cannot fix account " + account.getID() + ", it is locked");
                }
            } else if (this.itemPriceDoesNotMatch(account)) {
                anotherOne = true;
                if (this.fixItemPriceQuantityMismatch(account)) {
                    ++fixed;
                    fixedAccountList.add(account);
                }
            }
            if (!anotherOne) continue;
            ++detected;
            detectedAccountList.add(account);
        }
        String result = "Detected " + detected + " invalid total amounts, fixed " + fixed + System.lineSeparator();
        if (detectedAccountList.size() != 0) {
            int i;
            OrderMate.LOG.info("Detected Account List:");
            result = result + "Detected Account List:" + System.lineSeparator();
            for (i = 0; i < detectedAccountList.size(); ++i) {
                Account account = (Account)detectedAccountList.get(i);
                result = result + account.toString();
                if (i % 2 != 0) {
                    result = result + System.lineSeparator();
                }
                OrderMate.LOG.info(account.toString());
            }
            OrderMate.LOG.info("UnFixed Account List:");
            result = result + System.lineSeparator() + "UnFixed Account List:" + System.lineSeparator();
            i = 0;
            for (Account account : detectedAccountList) {
                if (fixedAccountList.contains(account)) continue;
                result = result + account.toString();
                if (i % 2 != 0) {
                    result = result + System.lineSeparator();
                }
                OrderMate.LOG.info(account.toString());
                ++i;
            }
        }
        return result;
    }

    private boolean itemPriceDoesNotMatch(Account acc) {
        Price rollingAmount = Price.ZERO_DOLLAR;
        for (SalesLineItem i : acc.getAllItems()) {
            if (i instanceof SalesCombo) {
                rollingAmount = rollingAmount.add(((SalesCombo)i).getSavedTotalPrice());
                continue;
            }
            rollingAmount = rollingAmount.add(i.getPrice());
        }
        return !acc.getSavedTotal().approximatelyEquals(rollingAmount);
    }

    private boolean fixItemPriceQuantityMismatch(Account acc) {
        if (acc.lock(User.getSystemUser())) {
            try {
                for (SalesLineItem i : acc.getAllItems()) {
                    if (!i.getQuantity().equals(SalesQuantity.ZERO) || i.getPrice().isZero()) continue;
                    if (i instanceof SalesCombo) {
                        for (SalesLineItem item : ((SalesCombo)i).getSalesItems()) {
                            if (!(item instanceof SalesItem) || item.getPrice().equals((Object)Price.ZERO_DOLLAR)) continue;
                            for (SalesComponent c : ((SalesItem)item).getComponentList()) {
                                c.removeAllPriceAdjustmentUsage();
                                SalesComponentSaveContext context = new SalesComponentSaveContext(c.getInventoryItem().getDecrementStockArea(item.getOriginalTerminal()), SalesQuantity.ZERO, SalesQuantity.ZERO);
                                c.prepareForSave((SaveContext)context);
                                c.saveChild();
                                c.getSavedTotalPrice();
                            }
                            item.setPrice(Price.ZERO_DOLLAR, new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser()));
                            item.saveChild();
                        }
                    }
                    i = (SalesLineItem)PersistenceManager.reacquire((PersistentObjectI)i);
                    i.setPrice(Price.ZERO_DOLLAR, new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser()));
                    i.saveChild();
                }
                acc.unlock();
                return this.itemPriceDoesNotMatch(acc);
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Could not fix anomaly in account:", (Throwable)ex);
                acc.unlock();
                return false;
            }
        }
        OrderMate.LOG.warn("Cannot fix account " + acc.getID() + ", it is locked");
        return false;
    }

    private String detectImbalance(List<Account> accounts) {
        StringBuilder SB = new StringBuilder();
        int count = 0;
        for (Account account : accounts) {
            if (!AccountState.CLOSED.equals((Object)account.getAccountState()) || account.isDebtorSale() || account.getSavedTotal().approximatelyEquals(account.getPaid())) continue;
            SB.append(account.getID() + " " + account.getType() + " " + account.getCreationDateTime() + " owing " + account.getDue());
            SB.append(System.lineSeparator());
            ++count;
        }
        return "Detected " + count + " unbalanced closed accounts: " + count + System.lineSeparator() + SB.toString();
    }
}

