/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.salestotakings;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.OfficeMateGuiHandler;
import officemate.screens.reports.jasper.JasperReportState;
import officemate.screens.reports.jasper.JasperToolbarFactory;
import officemate.screens.reports.salestotakings.SalesToTakingsAnomalyDetector;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.salestotakings.SalesToTakingsReportProvider;
import ordermate.database.users.AllPermissions;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;

public class SalesToTakingsReportState
extends JasperReportState {
    private static EventList<TradingDay> tradingDays;
    private ComboSearchField tradingDayComboSearchField;
    private final SalesToTakingsReportProvider provider = new SalesToTakingsReportProvider();

    public SalesToTakingsReportState() {
        super(null, "Sales To Takings", AllPermissions.ACCESS_SALES_REPORT, "Sales To Takings Breakdown Report");
        this.addAction((Action)((Object)new AnomalyCheckAction()));
        this.setReportProvider((ReportProvider)this.provider);
    }

    public static void clearTradingDays() {
        tradingDays.clear();
    }

    public static EventList<TradingDay> getTradingDays() {
        return tradingDays;
    }

    @Override
    protected void init() {
        super.init();
        tradingDays.clear();
        ArrayList allDays = new ArrayList(TradingDay.getAllTradingDays());
        Collections.reverse(allDays);
        tradingDays.addAll(allDays);
    }

    @Override
    public JasperToolbarFactory createJasperToolbarFactory() {
        return new JasperToolbarFactory(){

            @Override
            protected JPanel getCustomReportControlPanel() {
                JPanel panel = new JPanel();
                tradingDays = GlazedLists.eventList((Collection)SalesToTakingsReportState.this.getAllTradingDays());
                SalesToTakingsReportState.this.tradingDayComboSearchField = new ComboSearchField("Day", TradingDay.Properties.DATE, false, SalesToTakingsReportState.this.getRefreshAction(), tradingDays);
                panel.add(SalesToTakingsReportState.this.tradingDayComboSearchField.getJLabelForComponent());
                panel.add(SalesToTakingsReportState.this.tradingDayComboSearchField.getGuiComponent());
                SalesToTakingsReportState.this.tradingDayComboSearchField.setSelectedObject((Object)TradingDay.getCurrentTradingDay());
                return panel;
            }
        };
    }

    @Override
    public void refresh() {
        this.provider.setTradingDay((TradingDay)this.tradingDayComboSearchField.getSelectedObject());
        super.refresh();
        OfficeMateAdminGuiUtils.getInstance().refreshList(tradingDays, this.getAllTradingDays());
    }

    private List<TradingDay> getAllTradingDays() {
        ArrayList<TradingDay> allTradingDays = new ArrayList<TradingDay>(TradingDay.getAllTradingDays());
        Collections.reverse(allTradingDays);
        return allTradingDays;
    }

    class AnomalyCheckAction
    extends BasicAction {
        AnomalyCheckAction() {
            super("Detect Anomalies");
        }

        public void actionPerformed(ActionEvent e) {
            new SalesToTakingsAnomalyDetector(((SalesToTakingsReportProvider)SalesToTakingsReportState.this.getProvider()).getCompiler().getSearchTradingDay(), new OfficeMateGuiHandler()).start();
        }
    }
}

