/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.salesyearonyear;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.filter.implementation.FixedRangeSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.OffsetFunction;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.swing.Action;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.search.searchfield.TimeRangeSearchField;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.reports.sales.yearonyear.SalesYearOnYearReport;
import ordermate.database.searchers.reports.YearOnYearPeriod;
import ordermate.database.searchers.reports.sales.time.SalesYearOnYearReportSearcher;

class SearchController
extends ObjectPropertySearch<SalesYearOnYearReport> {
    private final EventList<PriceLevel> priceLevels = new BasicEventList();
    private EventList<Date> dates;
    private final YearOnYearPeriod period;

    public SearchController(SalesYearOnYearReportSearcher newSearcher, YearOnYearPeriod periodAdapter, EventList<SalesYearOnYearReport> eventObjectList) {
        super(SalesYearOnYearReport.class, newSearcher, eventObjectList);
        this.period = periodAdapter;
        RefreshAction action = new RefreshAction((Refreshable)this);
        FixedRangeSearchFilter searchFilter = newSearcher.getFixedRangeFilter();
        searchFilter.setOffsetFunction((OffsetFunction)periodAdapter.getDateOffset());
        newSearcher.addSearchFilter((SearchFilterI)searchFilter);
        this.dates = GlazedLists.eventList((Collection)periodAdapter.getDateList());
        this.addSearchField((SearchGuiField)new ComboSearchField(periodAdapter.getUnitOfTime(), (ISingleValueSearchFilter)searchFilter, false, (Action)action, this.dates, (Format)periodAdapter.getFormatter()));
        this.addSearchField((SearchGuiField)new ComboSearchField("Price Level", newSearcher.getPriceLevelFilter(), true, (Action)action, this.priceLevels));
        this.addSearchField(new TimeRangeSearchField(newSearcher.getTimeFilter(), (Action)action));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Sales Location", newSearcher.getSalesLocationFilter(), (Action)action, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations())));
        this.useSearchRefreshStrategy();
    }

    @Override
    public void reaquireSearchOptions() {
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.priceLevels, PriceLevel.getAllPriceLevels());
        GlazedListUtils.setAsList(this.dates, new ArrayList(this.period.getDateList()));
        super.reaquireSearchOptions();
    }
}

