/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.satr;

import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.Collection;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import officemate.components.search.AbstractObjectSearch;
import officemate.components.search.SearchBarPanel;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.reports.sata.SATAReport;
import ordermate.database.reports.sata.SATAReportBySIQCompiler;
import ordermate.database.sales.SalesItemQuantity;

class SATRSearch
extends AbstractObjectSearch<SATAReport> {
    private SATAReportBySIQCompiler compiler = SATAReportBySIQCompiler.getMonthCompiler((Date)new Date());
    private DateRangeSearchField customDateField;
    private MultiSelectComboSearchField terminalLocationField;
    private MultiSelectComboSearchField salesLocationField;
    private RefreshAction refresh;

    public SATRSearch(RefreshAction yourRefresh) {
        super(new BasicEventList());
        this.refresh = yourRefresh;
    }

    public SATAReportBySIQCompiler getCompiler() {
        return this.compiler;
    }

    @Override
    public void addToSearchPanel(JComponent comp) {
        ((SearchBarPanel)this.getSearchPanel()).add(comp);
    }

    @Override
    public void resetSearch() {
    }

    @Override
    public void reaquireSearchOptions() {
    }

    @Override
    protected JPanel createSearchPanel() {
        SearchBarPanel searchBar = new SearchBarPanel();
        this.customDateField = new DateRangeSearchField("Range", (IRangedQuerySearchFilter)new OptimisedDateRangeSearchFilter(SalesItemQuantity.Properties.CREATION_TIME, SQLDateType.TIMESTAMP), DateTimeUtils.getOneMonthAgoCal().getTime(), (Action)this.refresh);
        this.customDateField.useFixedDates();
        searchBar.addSearchField("", this.customDateField.getGuiComponent());
        this.salesLocationField = new MultiSelectComboSearchField("Sales Location", this.compiler.getSalesLocationFilter(), (Action)this.refresh, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations()));
        searchBar.addSearchField((SearchGuiField)this.salesLocationField);
        return searchBar;
    }

    @Override
    protected void doRefresh() {
        this.compiler.setDateRange((Date)this.customDateField.getSearchProperty().getStart(), (Date)this.customDateField.getSearchProperty().getEnd());
        this.compiler.clearCache();
        this.compiler.performReport();
    }
}

