/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.staff;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.reports.staff.AbstractStaffSoldReportSearch;
import ordermate.database.reports.sales.staff.AbstractStaffSoldReport;
import ordermate.database.searchers.reports.sales.staff.AbstractStaffSoldReportSearcher;
import ordermate.database.users.Permission;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import ordermate.signals.Signal;

public abstract class AbstractStaffSoldTableState<T extends AbstractStaffSoldReport>
extends AbstractTableState<T> {
    private AbstractStaffSoldReportSearch<T> search;

    public AbstractStaffSoldTableState(String name, Permission permission, String description) {
        super(name, permission, description);
    }

    @Override
    protected TableStateCentralArea<T> createCentralArea() {
        ColumnTableFormat format = this.createTableFormat();
        PersistentObjectTable table = new PersistentObjectTable(this.getObjectList(), format);
        return table;
    }

    public AbstractStaffSoldReportSearcher<T> getSearcher() {
        return ((AbstractStaffSoldReportSearch)this.getSearchFactory()).getSearcher();
    }

    @Override
    protected AbstractStaffSoldReportSearch<T> createSearchPanelFactory() {
        if (this.search == null) {
            this.search = this.createSearchControl();
        }
        return this.search;
    }

    public Signal getPeriodSignal() {
        return this.search.periodSignal;
    }

    @Override
    public AbstractStaffSoldReportSearch<T> getSearchFactory() {
        return this.createSearchPanelFactory();
    }

    protected boolean isFormattedLabel(PropertiedObject.Property property) {
        return AbstractStaffSoldReport.Properties.FORMATTED_LABEL.equals((Object)property);
    }

    protected ColumnTableFormat createTableFormat() {
        List<PropertiedObject.Property> props = this.getDisplayableProperties();
        Map<PropertiedObject.Property, Format> propFormats = this.getPropertyFormats();
        ColumnTableFormat tableFormat = new ColumnTableFormat();
        for (PropertiedObject.Property prop : props) {
            if (this.isFormattedLabel(prop)) {
                tableFormat.addColumn((ColumnFormat)new PropertyColumnFormat(this.getStaffSoldReportColumnLabel(), (PropertyAccessor)prop, propFormats.get(prop)));
                continue;
            }
            tableFormat.addColumn((ColumnFormat)new PropertyColumnFormat(prop.getUserVisibleLabel(), (PropertyAccessor)prop, propFormats.get(prop)));
        }
        return tableFormat;
    }

    protected Map<PropertiedObject.Property, Format> getPropertyFormats() {
        return new HashMap<PropertiedObject.Property, Format>();
    }

    protected List<PropertiedObject.Property> getDisplayableProperties() {
        ArrayList<PropertiedObject.Property> props = new ArrayList<PropertiedObject.Property>();
        props.add((PropertiedObject.Property)AbstractStaffSoldReport.Properties.FORMATTED_LABEL);
        props.add((PropertiedObject.Property)AbstractStaffSoldReport.Properties.FULLNAME);
        props.add(AbstractStaffSoldReport.Properties.QUANTITY);
        props.add(AbstractStaffSoldReport.Properties.TOTAL);
        return props;
    }

    protected abstract AbstractStaffSoldReportSearch<T> createSearchControl();

    protected abstract String getStaffSoldReportColumnLabel();
}

