/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.staff.contest;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.control.DateRangePanel;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.util.DateTimeUtils;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import officemate.screens.reports.jasper.JasperReportState;
import officemate.screens.reports.jasper.JasperToolbarFactory;
import ordermate.database.contest.Contest;
import ordermate.database.misc.DayPart;
import ordermate.database.queries.contest.ContestQueries;
import ordermate.database.reports.contest.ContestAggregateReportProvider;
import ordermate.database.reports.contest.ContestReportParams;
import ordermate.database.reports.contest.compiler.ContestAggregateReportCompiler;
import ordermate.database.users.AllPermissions;
import ordermate.gui.FieldPanelBuilder;
import ordermate.reports.dynamicjasper.ArbitraryPeriodReportAdapter;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;

public class ContestReportState
extends JasperReportState
implements Refreshable {
    private boolean updating = false;
    private ContestReportJasperToolbarFactory toolbar;

    public ContestReportState() {
        super(null, "Contest Reports", AllPermissions.ACCESS_SALES_REPORT, "View your Contest Reports");
    }

    @Override
    protected JasperToolbarFactory createJasperToolbarFactory() {
        this.toolbar = new ContestReportJasperToolbarFactory(new RefreshAction((Refreshable)this));
        return this.toolbar;
    }

    @Override
    public void init() {
        this.updating = true;
        super.init();
        this.toolbar.updateContests();
        this.updating = false;
    }

    @Override
    public void refresh() {
        if (this.updating) {
            return;
        }
        Contest contest = (Contest)this.toolbar.contestCombo.getSelectedItem();
        if (contest != null) {
            ContestReportParams contestReportParams = new ContestReportParams(contest);
            if (!DayPart.getAllDayPartsOrdered((boolean)true).isEmpty()) {
                contestReportParams.setGroupedByDayPart(true);
            } else {
                contestReportParams.setGroupedByDayPart(false);
            }
            contestReportParams.setPeriod((PeriodReportAdapter)new ArbitraryPeriodReportAdapter(DateTimeUtils.getStartOfDay((Date)this.toolbar.rangePanel.getStartDate()), DateTimeUtils.getEndOfDay((Date)this.toolbar.rangePanel.getEndDate())));
            ContestAggregateReportCompiler compiler = new ContestAggregateReportCompiler(contestReportParams);
            compiler.compileReport();
            this.setReportProvider((ReportProvider)new ContestAggregateReportProvider(compiler));
            this.displayReport();
        }
    }

    class ContestReportJasperToolbarFactory
    extends JasperToolbarFactory {
        private JComboBox contestCombo;
        private DateRangePanel rangePanel;
        private RefreshAction refresh;
        private JPanel holder;

        ContestReportJasperToolbarFactory(RefreshAction refresh) {
            this.refresh = refresh;
        }

        @Override
        protected JPanel getCustomReportControlPanel() {
            this.contestCombo = new JComboBox();
            this.contestCombo.addActionListener((ActionListener)this.refresh);
            ComponentUtils.setupComboBox((JComboBox)this.contestCombo);
            this.rangePanel = new DateRangePanel();
            this.rangePanel.addAction((Action)this.refresh);
            FieldPanelBuilder builder = new FieldPanelBuilder();
            builder.addRow("Contest", (Component)this.contestCombo);
            builder.addRow("Date Range", (Component)this.rangePanel);
            this.holder = builder.getPanel();
            this.holder.setLayout(new FlowLayout(0));
            return this.holder;
        }

        public void updateContests() {
            this.contestCombo.removeAllItems();
            for (Contest contest : PersistenceManager.getObjectList(Contest.class, (String)ContestQueries.getAllActiveContests().toString())) {
                this.contestCombo.addItem(contest);
            }
        }
    }
}

