/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.staff.deletion;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.screens.reports.staff.AbstractStaffSoldReportSearch;
import officemate.screens.reports.staff.AbstractStaffSoldTableState;
import officemate.screens.reports.staff.deletion.StaffDeletionReportSearch;
import ordermate.database.reports.sales.staff.StaffDeletedItemsReport;
import ordermate.database.users.Permission;

public class StaffDeletionReportTableState
extends AbstractStaffSoldTableState<StaffDeletedItemsReport> {
    public StaffDeletionReportTableState(Permission permission) {
        super("Items Deleted", permission, "Report for viewing the deleted items for each user and the monetary value of the deleted qunatities of items");
    }

    @Override
    protected TableStateCentralArea<StaffDeletedItemsReport> createCentralArea() {
        TableStateCentralArea<StaffDeletedItemsReport> centralTable = super.createCentralArea();
        return centralTable;
    }

    @Override
    protected AbstractStaffSoldReportSearch<StaffDeletedItemsReport> createSearchControl() {
        StaffDeletionReportSearch searcher = new StaffDeletionReportSearch((EventList<StaffDeletedItemsReport>)new BasicEventList());
        searcher.groupUserSignal.connect((Object)this, "gotGroupCheckbox");
        return searcher;
    }

    @Override
    protected String getStaffSoldReportColumnLabel() {
        return "Item Name";
    }

    @Override
    protected boolean isFormattedLabel(PropertiedObject.Property property) {
        return StaffDeletedItemsReport.Properties.FORMATTED_LABEL.equals((Object)property);
    }

    @Override
    protected Class<StaffDeletedItemsReport> getDisplayingType() {
        return StaffDeletedItemsReport.class;
    }

    public void gotGroupCheckbox(Boolean newValue) {
        if (newValue.booleanValue()) {
            ((PersistentObjectTable)this.getCentralArea()).groupOn("Ordered User", "Quantity", "Total");
        } else {
            ((PersistentObjectTable)this.getCentralArea()).groupOn(null, null);
        }
    }

    @Override
    protected Map<PropertiedObject.Property, Format> getPropertyFormats() {
        Map<PropertiedObject.Property, Format> toReturn = super.getPropertyFormats();
        toReturn.put((PropertiedObject.Property)StaffDeletedItemsReport.Properties.ORDERED_TIME, new Format(){

            @Override
            public StringBuffer format(Object date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
                if (date != null && date instanceof Date) {
                    Date tempDate = (Date)date;
                    toAppendTo.append(DateTimeUtils.getSQLTimestampFormat().format(tempDate));
                }
                return toAppendTo;
            }

            @Override
            public Object parseObject(String source, ParsePosition pos) {
                return null;
            }
        });
        toReturn.put(StaffDeletedItemsReport.Properties.DATE_DELETED, new Format(){

            @Override
            public StringBuffer format(Object date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
                if (date != null && date instanceof Date) {
                    Date tempDate = (Date)date;
                    toAppendTo.append(DateTimeUtils.getSQLTimestampFormat().format(tempDate));
                }
                return toAppendTo;
            }

            @Override
            public Object parseObject(String source, ParsePosition pos) {
                return null;
            }
        });
        return toReturn;
    }

    @Override
    protected List<PropertiedObject.Property> getDisplayableProperties() {
        ArrayList<PropertiedObject.Property> properties = new ArrayList<PropertiedObject.Property>();
        properties.add(0, (PropertiedObject.Property)StaffDeletedItemsReport.Properties.ACCOUNT);
        properties.add(1, (PropertiedObject.Property)StaffDeletedItemsReport.Properties.FORMATTED_LABEL);
        properties.add(2, (PropertiedObject.Property)StaffDeletedItemsReport.Properties.ORDERED_TIME);
        properties.add(3, (PropertiedObject.Property)StaffDeletedItemsReport.Properties.ORDERED_USER);
        properties.add(4, StaffDeletedItemsReport.Properties.DATE_DELETED);
        properties.add(5, (PropertiedObject.Property)StaffDeletedItemsReport.Properties.DELETED_USER);
        properties.add(6, StaffDeletedItemsReport.Properties.SIZE);
        properties.add(7, StaffDeletedItemsReport.Properties.PORTION);
        properties.add(8, StaffDeletedItemsReport.Properties.QUANTITY);
        properties.add(9, StaffDeletedItemsReport.Properties.TOTAL);
        return properties;
    }
}

