/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.stockonhand;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.sql.ResultSet;
import java.sql.SQLException;
import officemate.adminkit.table.QueryTableModel;
import ordermate.database.DBConnectionInterface;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.Quantity;

public class StockOnHandTableModel
extends QueryTableModel {
    public StockOnHandTableModel(String selQuery, DBConnectionInterface dc, int idField, int[] colsToShow, String[] colDisplayNames) {
        super(selQuery, dc, idField, colsToShow, colDisplayNames);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    @Override
    protected Object getTableValue(int row, int col, String colName, int dbColIndex, ResultSet rs) throws SQLException {
        if (dbColIndex == 7 || dbColIndex == 9) {
            return rs.getDouble(colName);
        }
        if (dbColIndex == 6 || dbColIndex == 8) {
            long measureFk = StockOnHandTableModel.getResultSetLong(rs, 3);
            MeasureUnitContainer unitContainer = (MeasureUnitContainer)PersistenceManager.getByID((long)measureFk, MeasureUnitContainer.class);
            double avgCost = rs.getDouble(colName);
            double qty = StockOnHandTableModel.getResultSetDouble(rs, 4);
            double displayQty = new Quantity(unitContainer, qty, true).doubleValue();
            return avgCost / displayQty;
        }
        if (dbColIndex == 5) {
            long measureFk = StockOnHandTableModel.getResultSetLong(rs, 3);
            MeasureUnitContainer unitContainer = (MeasureUnitContainer)PersistenceManager.getByID((long)measureFk, MeasureUnitContainer.class);
            return new Quantity(unitContainer, rs.getDouble(colName), true);
        }
        return super.getTableValue(row, col, colName, dbColIndex, rs);
    }

    @Override
    protected Number getTotalValue(int column, double rawValue, String colName, int dbColIndex) {
        if (dbColIndex == 7 || dbColIndex == 9) {
            return new Price(rawValue, 0.01);
        }
        return super.getTotalValue(column, rawValue, colName, dbColIndex);
    }
}

