/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.timesheet;

import officemate.adminkit.state.BasicOfficeMateState;
import officemate.screens.reports.CSVExportAction;
import officemate.screens.reports.timesheet.TimesheetTableState;
import officemate.screens.reports.timesheet.myobexport.MYOBPayRollCSVWriteStrategy;
import officemate.screens.reports.timesheet.quickbooksexport.QuickbooksPayRollCSVWriteStrategy;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.integration.finance.myob.mapping.FinanceExportStyle;
import ordermate.reports.table.ColumnFormat;

public class TimesheetActionHelper {
    private final TimesheetTableState tableState;
    private final ColumnFormat[] columns;
    private CSVExportAction<FinanceTimesheet> exportToCsv;
    private CSVExportAction<FinanceTimesheet> myobExport;
    private CSVExportAction<FinanceTimesheet> quickbooksExport;

    TimesheetActionHelper(TimesheetTableState tableState, ColumnFormat[] columns) {
        this.tableState = tableState;
        this.columns = columns;
    }

    public void addStateSpecificActions(BasicOfficeMateState state) {
        if (this.exportToCsv == null) {
            this.exportToCsv = new CSVExportAction(this.tableState.getObjectList(), this.columns, "payroll summary.csv");
        }
        state.addAction(this.exportToCsv);
        if (FinanceExportStyle.MYOB.equals((Object)AccountingIntegrationConfig.getInstance().getType())) {
            if (this.myobExport == null) {
                this.myobExport = new CSVExportAction(this.tableState.getObjectList(), this.columns, "myob_payroll.txt");
                this.myobExport.setName("MYOB Export");
                this.myobExport.setCSVWriteStrategy(new MYOBPayRollCSVWriteStrategy());
            }
            state.addAction(this.myobExport);
        } else if (FinanceExportStyle.Quickbooks.equals((Object)AccountingIntegrationConfig.getInstance().getType())) {
            if (this.quickbooksExport == null) {
                this.quickbooksExport = new CSVExportAction(this.tableState.getObjectList(), this.columns, "quickbooks_payroll.iif");
                this.quickbooksExport.setName("Quickbooks Export");
                this.quickbooksExport.setCSVWriteStrategy(new QuickbooksPayRollCSVWriteStrategy());
            }
            state.addAction(this.quickbooksExport);
        }
    }
}

