/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.timesheet;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.filter.BooleanSearchFilter;
import au.com.ordermate.search.searchfield.java.CheckBoxSearchField;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.ListCellRenderer;
import officemate.components.renderers.DynamicListCellRenderer;
import officemate.components.search.ObjectPropertySearch;
import officemate.screens.reports.timesheet.DepartmentComparator;
import officemate.screens.reports.timesheet.UserComparator;
import ordermate.database.departments.Department;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.queries.department.DepartmentQueries;
import ordermate.database.queries.users.UserQueries;
import ordermate.database.searchers.reports.timesheet.FinanceTimesheetSearcher;
import ordermate.database.users.User;
import ordermate.gui.themes.OrderMateTheme;

public class TimesheetSearchState
extends ObjectPropertySearch<FinanceTimesheet> {
    private EventList<User> userList = new BasicEventList();
    private EventList<Department> deptList = new BasicEventList();
    private FinanceTimesheetSearcher searcher;
    private DateRangeSearchField dateRangeField;
    private MultiSelectComboSearchField userField;
    private MultiSelectComboSearchField deptField;
    private CheckBoxSearchField showDeletedUsers;
    private Action usersFilterAction = new BasicAction(){

        public void actionPerformed(ActionEvent e) {
            TimesheetSearchState.this.updateUserList();
        }
    };

    public TimesheetSearchState(EventList<FinanceTimesheet> eventObjectList) {
        super(FinanceTimesheet.class, eventObjectList);
        RefreshAction refresh = new RefreshAction((Refreshable)this);
        refresh.setEnabled(false);
        this.searcher = (FinanceTimesheetSearcher)this.getPropertySearcher();
        this.updateUserList();
        this.dateRangeField = new DateRangeSearchField("Date Range", this.searcher.getTradingDayDateFilter(), new Date(), (Action)refresh);
        this.userField = new MultiSelectComboSearchField("User", (Action)refresh, this.userList, null, this.searcher.getUserFilter(), new JCheckBoxCellRenderer());
        this.userField.setRenderer((ListCellRenderer)new DynamicListCellRenderer<User>(){

            @Override
            protected void extraRenderStep(User value, DefaultListCellRenderer renderer) {
                if (value.getSystemState().equals("DELETED")) {
                    renderer.setForeground(OrderMateTheme.ORDERMATE_RED);
                }
            }
        });
        this.deptField = new MultiSelectComboSearchField("Department", (Action)refresh, this.deptList, null, this.searcher.getDepartmentFilter(), new JCheckBoxCellRenderer());
        this.showDeletedUsers = new CheckBoxSearchField("Show Deleted Users", (BooleanSearchFilter)this.searcher.getSystemStateSearchFilter(), this.usersFilterAction).not().setComparisonValue((Object)0).filterWhenDeselected(false);
        this.addSearchField((SearchGuiField)this.dateRangeField);
        this.addSearchField((SearchGuiField)this.userField);
        this.addSearchField((SearchGuiField)this.deptField);
        this.addSearchField((SearchGuiField)this.showDeletedUsers);
        this.useSearchRefreshStrategy();
        refresh.setEnabled(true);
    }

    public FinanceTimesheetSearcher getSearcher() {
        return this.searcher;
    }

    @Override
    protected ObjectQuerySearcher<FinanceTimesheet> constructPropertySearcher() {
        return new FinanceTimesheetSearcher();
    }

    @Override
    public void resetSearch() {
        this.updateUserList();
        super.resetSearch();
    }

    private void updateUserList() {
        this.userList.clear();
        this.userList.addAll(this.getUsers());
        Collections.sort(this.userList, new UserComparator());
        this.deptList.clear();
        this.deptList.addAll((Collection)DepartmentQueries.getAllDepartments());
        Collections.sort(this.deptList, new DepartmentComparator());
    }

    private List<User> getUsers() {
        List users = UserQueries.getUsersForTimesheetReport();
        EventList filteredUsers = GlazedLists.eventList((Collection)users);
        if (this.showDeletedUsers != null) {
            boolean isUsersDeleted = ((JCheckBox)this.showDeletedUsers.getGuiComponent()).isSelected();
            for (User user : users) {
                if (isUsersDeleted || !user.getSystemState().equals("DELETED")) continue;
                filteredUsers.remove((Object)user);
            }
        }
        return filteredUsers;
    }

    public Date getStartDate() {
        return this.dateRangeField.getDateRangePanel().getStartDate();
    }

    public Date getEndDate() {
        return this.dateRangeField.getDateRangePanel().getEndDate();
    }
}

