/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.timesheet.myobexport;

import au.com.ordermate.persistence.CSVPropertiedObjExporter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.csvwritestrategy.PropertiedObjCSVWriteStrategy;
import au.com.ordermate.persistence.csvwritestrategy.csvcolumn.CSVColumn;
import au.com.ordermate.persistence.csvwritestrategy.csvcolumn.PropertyAccessorCSVColumn;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.MathsUtils;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import officemate.screens.reports.timesheet.myobexport.MYOBExportEntry;
import ordermate.database.finance.timesheet.FinanceTimesheet;

public class MYOBPayRollCSVWriteStrategy
implements PropertiedObjCSVWriteStrategy<FinanceTimesheet> {
    public Map<Class<? extends PropertiedObject>, List<CSVColumn>> getClassColumnMap() {
        Class<MYOBExportEntry> toExport = MYOBExportEntry.class;
        ArrayList<PropertyAccessorCSVColumn> cols = new ArrayList<PropertyAccessorCSVColumn>();
        for (PropertiedObject.Property prop : PropertiedObject.PropsHelper.getProperties(toExport)) {
            cols.add(new PropertyAccessorCSVColumn((PropertyAccessor)prop));
        }
        HashMap<Class<? extends PropertiedObject>, List<CSVColumn>> toReturn = new HashMap<Class<? extends PropertiedObject>, List<CSVColumn>>();
        toReturn.put(toExport, cols);
        return toReturn;
    }

    public List<PropertiedObject> compileExportData(List<FinanceTimesheet> toExport) {
        ArrayList<PropertiedObject> lines = new ArrayList<PropertiedObject>();
        for (FinanceTimesheet timesheet : toExport) {
            if (!this.checkIsValidDataToExport(timesheet)) continue;
            this.exportObject(lines, timesheet);
        }
        return lines;
    }

    private void exportObject(List<PropertiedObject> lines, FinanceTimesheet timesheet) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(timesheet.getReportingTimeIn());
        while (cal.getTime().before(timesheet.getReportingTimeOut())) {
            Date endOfTimeWorkedToday = this.getEndOfWorkToday(cal.getTime(), timesheet.getReportingTimeOut());
            double timeInHrs = this.getTimeInHours(cal.getTime(), endOfTimeWorkedToday);
            lines.add(new MYOBExportEntry(timesheet.getPayrollId(), this.getDateFormatter().format(cal.getTime()), timesheet.getUser().getName(), timesheet.getDepartment().getName(), timeInHrs));
            cal.setTime(endOfTimeWorkedToday);
        }
    }

    private boolean checkIsValidDataToExport(FinanceTimesheet timesheet) {
        return timesheet.getPayrollId() != null && !timesheet.getPayrollId().trim().isEmpty();
    }

    private DateFormat getDateFormatter() {
        return DateTimeUtils.getShortDateFormat();
    }

    private double getTimeInHours(Date startDiff, Date endDiff) {
        long millis = DateTimeUtils.getDifferenceInMillisecs((Date)startDiff, (Date)endDiff);
        double time = (double)millis / 3600000.0;
        return MathsUtils.roundDoubleToDecPlaces((double)time, (int)2);
    }

    private Date getEndOfWorkToday(Date newStart, Date end) {
        Date endOfToday = this.getStartOfNextDay(newStart);
        if (endOfToday.before(end)) {
            return endOfToday;
        }
        return end;
    }

    private Date getStartOfNextDay(Date toUse) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(toUse);
        cal.add(6, 1);
        Date endOfToday = DateTimeUtils.getStartOfDay((Date)cal.getTime());
        return endOfToday;
    }

    public void configureExporter(CSVPropertiedObjExporter<FinanceTimesheet> exporter) {
    }
}

