/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.timesheet.quickbooksexport;

import au.com.ordermate.persistence.CSVPropertiedObjExporter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.csvwritestrategy.PropertiedObjCSVWriteStrategy;
import au.com.ordermate.persistence.csvwritestrategy.csvcolumn.CSVColumn;
import au.com.ordermate.persistence.csvwritestrategy.csvcolumn.ConstantCSVColumn;
import au.com.ordermate.persistence.csvwritestrategy.csvcolumn.PropertyAccessorCSVColumn;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.StringUtils;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import officemate.screens.reports.timesheet.quickbooksexport.QuickbooksEmpExportEntity;
import officemate.screens.reports.timesheet.quickbooksexport.QuickbooksHeaderExportEntity;
import officemate.screens.reports.timesheet.quickbooksexport.QuickbooksTimeactExportEntity;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.integration.accounting.settings.QuickbooksConfiguration;
import ordermate.database.users.User;

public class QuickbooksPayRollCSVWriteStrategy
implements PropertiedObjCSVWriteStrategy<FinanceTimesheet> {
    public void configureExporter(CSVPropertiedObjExporter<FinanceTimesheet> exporter) {
        exporter.setCSVHeaderStyle(CSVPropertiedObjExporter.CSVHeaderStyle.ALWAYS);
        exporter.setAddwhiteSpace(true);
        exporter.setQuote('\u0000');
    }

    public Map<Class<? extends PropertiedObject>, List<CSVColumn>> getClassColumnMap() {
        HashMap<Class<? extends PropertiedObject>, List<CSVColumn>> toReturn = new HashMap<Class<? extends PropertiedObject>, List<CSVColumn>>();
        ArrayList<Object> headerCols = new ArrayList<Object>();
        headerCols.add(new ConstantCSVColumn("!TIMERHDR", "TIMERHDR"));
        headerCols.add(new ConstantCSVColumn("VER", "8"));
        headerCols.add(new ConstantCSVColumn("REL", "0"));
        PropertiedObject.Property coNameProp = QuickbooksHeaderExportEntity.Properties.COMPANY_NAME;
        headerCols.add(new PropertyAccessorCSVColumn(StringUtils.capitalize((String)coNameProp.getName()), (PropertyAccessor)coNameProp));
        headerCols.add(new ConstantCSVColumn("IMPORTEDBEFORE", "N"));
        headerCols.add(new ConstantCSVColumn("FROMTIMER", "Y"));
        PropertiedObject.Property coCreateTimeProp = QuickbooksHeaderExportEntity.Properties.COMPANY_CREATE_TIME;
        headerCols.add(new PropertyAccessorCSVColumn(StringUtils.capitalize((String)coCreateTimeProp.getName()), (PropertyAccessor)coCreateTimeProp));
        toReturn.put(QuickbooksHeaderExportEntity.class, headerCols);
        ArrayList<Object> empCols = new ArrayList<Object>();
        empCols.add(new ConstantCSVColumn("!EMP", "EMP"));
        PropertiedObject.Property nameProp = QuickbooksEmpExportEntity.Properties.NAME;
        empCols.add(new PropertyAccessorCSVColumn(StringUtils.capitalize((String)nameProp.getName()), (PropertyAccessor)nameProp));
        PropertiedObject.Property firstNameProp = QuickbooksEmpExportEntity.Properties.FIRST_NAME;
        empCols.add(new PropertyAccessorCSVColumn(StringUtils.capitalize((String)firstNameProp.getName()), (PropertyAccessor)firstNameProp));
        PropertiedObject.Property lastNameProp = QuickbooksEmpExportEntity.Properties.LAST_NAME;
        empCols.add(new PropertyAccessorCSVColumn(StringUtils.capitalize((String)lastNameProp.getName()), (PropertyAccessor)lastNameProp));
        toReturn.put(QuickbooksEmpExportEntity.class, empCols);
        ArrayList<Object> timeactCols = new ArrayList<Object>();
        timeactCols.add(new ConstantCSVColumn("!TIMEACT", "TIMEACT"));
        PropertiedObject.Property dateProp = QuickbooksTimeactExportEntity.Properties.DATE;
        timeactCols.add(new PropertyAccessorCSVColumn(StringUtils.capitalize((String)dateProp.getName()), (PropertyAccessor)dateProp));
        PropertiedObject.Property empProp = QuickbooksTimeactExportEntity.Properties.EMP;
        timeactCols.add(new PropertyAccessorCSVColumn(StringUtils.capitalize((String)empProp.getName()), (PropertyAccessor)empProp));
        PropertiedObject.Property durationProp = QuickbooksTimeactExportEntity.Properties.DURATION;
        timeactCols.add(new PropertyAccessorCSVColumn(StringUtils.capitalize((String)durationProp.getName()), (PropertyAccessor)durationProp));
        timeactCols.add(new ConstantCSVColumn("NOTE", ""));
        timeactCols.add(new ConstantCSVColumn("XFERTOPAYROLL", "N"));
        timeactCols.add(new ConstantCSVColumn("BILLINGSTATUS", "0"));
        toReturn.put(QuickbooksTimeactExportEntity.class, timeactCols);
        return toReturn;
    }

    public List<PropertiedObject> compileExportData(List<FinanceTimesheet> toExport) {
        ArrayList<PropertiedObject> lines = new ArrayList<PropertiedObject>();
        this.exportHeader(lines);
        for (FinanceTimesheet timesheet : toExport) {
            if (!this.checkIsValidDataToExport(timesheet)) continue;
            this.exportObject(lines, timesheet);
        }
        return lines;
    }

    private void exportHeader(List<PropertiedObject> lines) {
        lines.add(new QuickbooksHeaderExportEntity(QuickbooksConfiguration.getInstance().getCompanyName(), QuickbooksConfiguration.getInstance().getCompanyCreationTime()));
    }

    private void exportObject(List<PropertiedObject> lines, FinanceTimesheet timesheet) {
        User user = timesheet.getUser();
        lines.add(new QuickbooksEmpExportEntity(user.getName(), user.getFirstName(), user.getLastName()));
        lines.add(new QuickbooksTimeactExportEntity(this.getDateFormatter().format(timesheet.getTimeIn()), user.getName(), DateTimeUtils.toHoursMinutes((long)timesheet.getTotalMillis())));
    }

    private boolean checkIsValidDataToExport(FinanceTimesheet timesheet) {
        return timesheet.getPayrollId() != null && !timesheet.getPayrollId().trim().isEmpty();
    }

    private DateFormat getDateFormatter() {
        return DateTimeUtils.getLongFormat();
    }
}

