/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.tips;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import officemate.components.search.AbstractObjectSearch;
import officemate.components.search.searchfield.TimeRangeSearchField;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.ConfigShift;
import ordermate.database.reports.tips.TipsReport;
import ordermate.database.reports.tips.TipsReportSearcher;
import ordermate.gui.FieldPanelBuilder;

public class TipsReportSearchControl
extends AbstractObjectSearch<TipsReport> {
    private DateRangeSearchField dateRangePanel;
    private TimeRangeSearchField timeRangePanel;
    private MultiSelectComboSearchField shiftPanel;
    private MultiSelectComboSearchField salesLocationField;
    private TipsReportSearcher searcher;
    private JCheckBox shiftBox = new JCheckBox("Group By Shift");
    private JCheckBox financeUnitBox = new JCheckBox("Show All Finance Units");
    private FieldPanelBuilder builder = new FieldPanelBuilder();
    private final List<ConfigShift> configShifts = ConfigShift.getAllConfigShifts();

    public TipsReportSearchControl(TipsReportSearcher searcher, EventList<TipsReport> dataList) {
        super(dataList);
        this.searcher = searcher;
        RefreshAction refresh = new RefreshAction((Refreshable)this);
        this.dateRangePanel = new DateRangeSearchField("", searcher.getDateRangeFilter(), DateTimeUtils.getThreeMonthsAgoCal().getTime(), (Action)refresh);
        this.timeRangePanel = new TimeRangeSearchField(searcher.getTimeRangeFilter(), (Action)refresh);
        this.shiftPanel = new MultiSelectComboSearchField("Shift", null, GlazedLists.eventList(this.configShifts), null, (MultiOptionSearchFilter)searcher.getShiftFilter(), new JCheckBoxCellRenderer());
        this.builder.addRow("Trading Day Range", this.dateRangePanel.getGuiComponent());
        this.builder.addRow("All Day", this.timeRangePanel.getGuiComponent());
        this.builder.addRow("Shift", (Component)this.shiftPanel.getGuiComponent());
        this.salesLocationField = new MultiSelectComboSearchField("Sales Location", searcher.getSalesLocationFilter(), (Action)refresh, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations()));
        this.builder.addRow("Sales Location", (Component)this.salesLocationField.getGuiComponent());
        JPanel panel = new JPanel();
        this.shiftBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TipsReportSearchControl.this.doRefresh();
            }
        });
        this.financeUnitBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TipsReportSearchControl.this.doRefresh();
            }
        });
        panel.add(this.shiftBox);
        panel.add(this.financeUnitBox);
        this.builder.addRow("", (Component)panel);
    }

    @Override
    public void resetSearch() {
        this.dateRangePanel.reset();
        this.timeRangePanel.reset();
        this.shiftPanel.reset();
        this.shiftBox.setSelected(false);
        this.financeUnitBox.setSelected(false);
    }

    @Override
    public JPanel createSearchPanel() {
        return this.builder.getPanel();
    }

    @Override
    public void doRefresh() {
        this.dateRangePanel.getSearchProperty();
        this.timeRangePanel.getSearchProperty();
        this.shiftPanel.getSearchProperty();
        this.searcher.setShowFinanceUnits(this.financeUnitBox.isSelected());
        this.searcher.setGroupByShift(this.shiftBox.isSelected());
        this.clearObjectList();
        this.copyIntoObjectList(this.searcher.search());
    }

    public JCheckBox getShiftBox() {
        return this.shiftBox;
    }

    public JCheckBox getFinanceUnitBox() {
        return this.financeUnitBox;
    }

    @Override
    public void reaquireSearchOptions() {
    }

    @Override
    public void addToSearchPanel(JComponent comp) {
    }
}

