/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.transaction;

import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.util.DateTimeUtils;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import javax.swing.table.TableModel;
import officemate.adminkit.state.SearchGuiState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.ColumnValueResolver;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.ResolvingColumnFormat;
import officemate.components.table.SimpleTotalCalculator;
import officemate.components.table.TableStateCentralArea;
import officemate.components.table.TotalTableModel;
import officemate.components.table.TotalsTableModelBuilder;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.PropertyAccessorColumnFormat;
import officemate.screens.reports.transaction.FinanceTransactionSearch;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.sales.Account;
import ordermate.database.searchers.finance.FinanceTransactionSearcher;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class FinanceTransactionSearchState
extends AbstractTableState<FinanceTransaction>
implements SearchGuiState<FinanceTransaction> {
    private FinanceTransactionSearcher searcher = new FinanceTransactionSearcher();

    public FinanceTransactionSearchState() {
        super("Search", null, "Select transactions to report on.");
    }

    @Override
    protected TableStateCentralArea<FinanceTransaction> createCentralArea() {
        ColumnValueResolver<FinanceTransaction, String> eftposResolver = new ColumnValueResolver<FinanceTransaction, String>(){

            @Override
            public String resolveValue(FinanceTransaction value) {
                if (value instanceof EftposTransaction) {
                    return ((EftposTransaction)value).getVirtualEftpos() != null ? ((EftposTransaction)value).getVirtualEftpos().getLabel() : "None";
                }
                return null;
            }
        };
        ColumnTableFormat colFormat = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat("Shift", (PropertyAccessor)FinanceTransaction.Properties.SHIFT, null), new PropertyColumnFormat("Timestamp", (PropertyAccessor)FinanceTransaction.Properties.CREATION_TIME, (Format)DateTimeUtils.getConsistent24HourReportDateFormat()), new PropertyColumnFormat("State", FinanceTransaction.Properties.SYSTEM_STATE), new PropertyColumnFormat("Txn ID", FinanceTransaction.Properties.ID), new PropertyColumnFormat("User", FinanceTransaction.Properties.USER), new PropertyColumnFormat("CashDrawer", FinanceTransaction.Properties.CASH_DRAWER), new PropertyColumnFormat("Terminal", FinanceTransaction.Properties.TERMINAL), new PropertyColumnFormat("Reference", (PropertiedObject.Property)FinanceTransaction.Properties.TRIMMED_REF), new PropertyAccessorColumnFormat("Account ID", new PropertiedObject.Property[]{FinanceTransaction.Properties.ACCOUNT, Account.Properties.ID}, (Format)new DecimalFormat("0")), new PropertyAccessorColumnFormat("Account Type", new PropertiedObject.Property[]{FinanceTransaction.Properties.ACCOUNT, Account.Properties.ACCOUNT_TYPE}, null), new ResolvingColumnFormat("Eftpos", String.class, eftposResolver), new PropertyColumnFormat("Source", FinanceTransaction.Properties.SOURCE), new PropertyAccessorColumnFormat("Type", new PropertiedObject.Property[]{FinanceTransaction.Properties.SUB_TYPE, FinanceUnit.Properties.TYPE}, null), new PropertyColumnFormat("Unit", FinanceTransaction.Properties.SUB_TYPE), new PropertyColumnFormat("Tendered", FinanceTransaction.Properties.TENDERED), new PropertyColumnFormat("Paid Ex Surch & Tip", (PropertiedObject.Property)FinanceTransaction.Properties.PAID_EX_SURCH_EX_TIP), new PropertyColumnFormat("Surcharge", FinanceTransaction.Properties.SURCHARGE), new PropertyColumnFormat("Tip", FinanceTransaction.Properties.TIP), new PropertyColumnFormat("CashOut", FinanceTransaction.Properties.CASH_OUT), new PropertyColumnFormat("Paid Inc Surch", FinanceTransaction.Properties.PAID), new PropertyColumnFormat("Paid Inc Tip", (PropertiedObject.Property)FinanceTransaction.Properties.PAID_EX_SURCH_INC_TIP), new PropertyColumnFormat("Txn Total", (PropertiedObject.Property)FinanceTransaction.Properties.PAID_TOTAL)});
        PersistentObjectTable<FinanceTransaction> table = new PersistentObjectTable<FinanceTransaction>(this.getObjectList(), colFormat);
        ArrayList<String> totalIgnore = new ArrayList<String>();
        for (ColumnFormat format : colFormat.getColumns()) {
            totalIgnore.add(format.getName());
            if (!"Unit".equals(format.getName())) continue;
            break;
        }
        TotalsTableModelBuilder totalsBuilder = new TotalsTableModelBuilder(totalIgnore);
        SimpleTotalCalculator txnCalc = new SimpleTotalCalculator(){

            @Override
            public Number calculateTotal(TableModel tableModel, TotalTableModel totalsModel, int column) {
                double total = 0.0;
                for (int i = 0; i < tableModel.getRowCount(); ++i) {
                    Number value;
                    if (!"ACTIVE".equals(tableModel.getValueAt(i, 2)) || (value = (Number)tableModel.getValueAt(i, column)) == null) continue;
                    total += value.doubleValue();
                }
                return total;
            }
        };
        totalsBuilder.setDefaultCalculator(txnCalc);
        table.setTotalsBuilder(totalsBuilder);
        table.getTable().getColumnExt((Object)FinanceTransaction.Properties.TENDERED).setVisible(false);
        table.getTable().getColumnExt((Object)FinanceTransaction.Properties.USER).setVisible(false);
        table.getTable().getColumnExt((Object)FinanceTransaction.Properties.SOURCE).setVisible(false);
        table.getTable().getColumnExt((Object)FinanceTransaction.Properties.TERMINAL).setVisible(false);
        table.getTable().getColumnExt((Object)FinanceUnit.Properties.TYPE).setVisible(false);
        return table;
    }

    @Override
    protected Class<FinanceTransaction> getDisplayingType() {
        return FinanceTransaction.class;
    }

    @Override
    public ObjectQuerySearcher<FinanceTransaction> getSearcher() {
        return this.searcher;
    }

    @Override
    protected OfficeMateObjectSearch<FinanceTransaction> createSearchPanelFactory() {
        return new FinanceTransactionSearch(this.searcher);
    }
}

