/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.transmitreport;

import au.com.ordermate.persistence.Executable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import officemate.screens.reports.transmitreport.ReportTransmissionPanel;
import ordermate.integration.storegroup.GenerateAndExportExecutable;

public class MonthlyReportPanel
extends ReportTransmissionPanel {
    private JSpinner dateSpinner;

    @Override
    protected void setupComponents() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        SpinnerDateModel dateModel = new SpinnerDateModel(cal.getTime(), null, cal.getTime(), 2);
        this.dateSpinner = new JSpinner(dateModel);
        JSpinner.DateEditor editor = new JSpinner.DateEditor(this.dateSpinner, "MMMM yyyy");
        this.dateSpinner.setEditor(editor);
        this.add(new JLabel("Select Date"));
        this.add(this.dateSpinner);
        this.dateSpinner.setToolTipText("The date to be transmitted.");
    }

    @Override
    protected Executable generateAndSend(List<String> listOfEmails) {
        return new GenerateAndExportExecutable((Date)this.dateSpinner.getValue(), listOfEmails);
    }

    @Override
    public String getLabel() {
        return "Monthly Sales and Variance";
    }

    @Override
    String getGenerationMessage() {
        StringBuilder SB = new StringBuilder("The report for the month of ");
        SB.append(new SimpleDateFormat("MMMM yyyy").format((Date)this.dateSpinner.getValue()));
        SB.append(" will be generated and sent shortly.");
        SB.append("\n\nThis operation may take several minutes to complete.");
        return SB.toString();
    }
}

