/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.transmitreport;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.screens.reports.transmitreport.DailyDetailedReportPanel;
import officemate.screens.reports.transmitreport.EftposSummaryReportPanel;
import officemate.screens.reports.transmitreport.MonthlyDetailedReportPanel;
import officemate.screens.reports.transmitreport.MonthlyReportPanel;
import officemate.screens.reports.transmitreport.ReportTransmissionPanel;
import officemate.screens.reports.transmitreport.WeekEndingDetailedReportPanel;
import ordermate.database.misc.StoreGroup;
import ordermate.database.users.AllPermissions;
import ordermate.gui.FieldPanelBuilder;

@Deprecated
public class ReportTransmitState
extends BasicOfficeMateState
implements ActionListener,
ListSelectionListener {
    private static final int MINIMUM_LENGTH = 5;
    private JList emailList;
    private JTabbedPane tab;
    private JButton exportBut;
    private JButton addEmailBut;
    private JButton removeEmailBut;
    private JButton defaultEmailBut;
    private String[] defaultListOfEmails;
    private List<String> listOfEmails;
    private Thread executingThread;

    public ReportTransmitState() {
        super("Report Transmission", AllPermissions.MONTHLY_EXPORT, "Transmit a report at the click of a button.");
    }

    @Override
    protected void onStart() {
        if (this.isFirstRun()) {
            this.setupComponents();
        }
        super.onStart();
    }

    private void setupComponents() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.tab = new JTabbedPane();
        for (ReportTransmissionPanel nextPanel : this.createPanels()) {
            this.tab.add((Component)nextPanel, nextPanel.getLabel());
        }
        this.tab.setPreferredSize(new Dimension(400, 100));
        builder.addRow("Select Report", (Component)this.tab);
        builder.addSeparator("");
        this.exportBut = new JButton("Send Report...");
        this.exportBut.addActionListener(this);
        builder.addRow("Generate and Send", (Component)this.exportBut, "This will generate and send the selected report.");
        JPanel listPanel = new JPanel(new BorderLayout());
        this.emailList = new JList();
        this.emailList.addListSelectionListener(this);
        listPanel.setPreferredSize(new Dimension(350, 80));
        listPanel.add((Component)new JScrollPane(this.emailList), "Center");
        JPanel buttonHolder = new JPanel();
        this.addEmailBut = new JButton("Add Email...");
        buttonHolder.add(this.addEmailBut);
        this.removeEmailBut = new JButton("Remove Email");
        buttonHolder.add(this.removeEmailBut);
        this.defaultEmailBut = new JButton("Reset to Default");
        buttonHolder.add(this.defaultEmailBut);
        this.addEmailBut.addActionListener(this);
        this.removeEmailBut.addActionListener(this);
        this.removeEmailBut.setEnabled(false);
        this.defaultEmailBut.addActionListener(this);
        listPanel.add((Component)buttonHolder, "South");
        builder.addRow("Email To...", (Component)listPanel, "Set the list of emails that the report is sent to.");
        this.setScreenPanel(builder.getPanel());
        this.createEmailList();
        this.resetToDefaultEmails();
    }

    private List<ReportTransmissionPanel> createPanels() {
        ArrayList<ReportTransmissionPanel> list = new ArrayList<ReportTransmissionPanel>();
        list.add(new MonthlyReportPanel());
        list.add(new EftposSummaryReportPanel());
        list.add(new DailyDetailedReportPanel());
        list.add(new WeekEndingDetailedReportPanel());
        list.add(new MonthlyDetailedReportPanel());
        return list;
    }

    private void createEmailList() {
        this.listOfEmails = new ArrayList<String>();
        String emails = StoreGroup.getInstance().getEmailAddress();
        if (emails == null) {
            emails = "";
        }
        this.defaultListOfEmails = emails.split(",");
    }

    private void resetToDefaultEmails() {
        this.listOfEmails.clear();
        for (int i = 0; i < this.defaultListOfEmails.length; ++i) {
            this.listOfEmails.add(this.defaultListOfEmails[i]);
        }
        this.updateEmailList();
    }

    private void removeSelectedEmail() {
        Object[] toRemove = this.emailList.getSelectedValues();
        if (toRemove.length > 0) {
            for (int i = 0; i < toRemove.length; ++i) {
                this.listOfEmails.remove(toRemove[i]);
            }
            this.updateEmailList();
        }
    }

    private void addEmail() {
        String input = JOptionPane.showInputDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Please enter an email address.\nThis will not alter the default set of emails.", "Add Email", 3);
        if (input == null) {
            input = "";
        }
        input = input.trim().toLowerCase();
        String error = null;
        if (input.length() < 5) {
            error = "That email is too short to be valid.";
        } else if (!input.contains("@")) {
            error = "An email address will require a format of: recipient@domain";
        } else if (this.listOfEmails.contains(input)) {
            error = "That email address already exists within the list.";
        }
        if (error == null) {
            this.listOfEmails.add(input);
            this.updateEmailList();
        } else if (input.length() > 0) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), error, "Cannot add address", 2);
        }
    }

    private void updateEmailList() {
        this.exportBut.setEnabled(this.listOfEmails.size() != 0);
        this.emailList.setListData(this.listOfEmails.toArray());
    }

    private boolean isAllowedToExport() {
        boolean fine;
        boolean bl = fine = this.executingThread == null || !this.executingThread.isAlive();
        if (!fine) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "A previous export is already being generated.\n\nPlease try again later.", "Reporting in progress", 2);
        }
        return fine;
    }

    private void generateAndSend() {
        ReportTransmissionPanel currentPanel = (ReportTransmissionPanel)this.tab.getSelectedComponent();
        final Executable exec = currentPanel.generateAndSend(this.listOfEmails);
        if (exec == null) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "That doesn't appear to be a valid report, no report generated.", "Cannot Generate Report", 2);
            return;
        }
        this.executingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                PersistenceManager.getServerConnection().runSync(exec);
            }
        });
        this.executingThread.setDaemon(true);
        this.executingThread.start();
        JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), currentPanel.getGenerationMessage(), "Generating Report", 1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.exportBut) {
            if (this.isAllowedToExport()) {
                this.generateAndSend();
            }
        } else if (source == this.addEmailBut) {
            this.addEmail();
        } else if (source == this.removeEmailBut) {
            this.removeSelectedEmail();
        } else if (source == this.defaultEmailBut) {
            this.resetToDefaultEmails();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            Object[] values = this.emailList.getSelectedValues();
            this.removeEmailBut.setEnabled(values.length > 0);
        }
    }
}

