/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.usage;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.guicore.task.AbstractGuiTask;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.DateDMY;
import au.com.ordermate.util.GuiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import officemate.adminkit.DateTimeRangePanel;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.print.Printing;
import officemate.adminkit.search.SearchDialog;
import officemate.adminkit.searchpanels.StockItemSearchPanel;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.table.GroupedTable;
import officemate.adminkit.table.LinkedTotalTable;
import officemate.adminkit.table.PriceGroupedTableModel;
import officemate.adminkit.table.QueryTable;
import officemate.adminkit.table.QueryTableModel;
import officemate.adminkit.tree.stockgroup.StockGroupTreePanel;
import officemate.screens.ObjectManagerI;
import officemate.screens.reports.usage.StockUsageCellRenderer;
import officemate.screens.reports.usage.StockUsageGroupedCellRenderer;
import officemate.screens.reports.usage.StockUsageTableModel;
import ordermate.database.reports.stock.usage.StockUsageReportQuery;
import ordermate.database.reports.stock.usage.StockUsageReportSearcher;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.users.AllPermissions;

public class StockUsageState
extends BasicOfficeMateState {
    private JPanel innerPanel;
    private JPanel northPanel;
    private JPanel northWestPanel;
    private JPanel tablePanel;
    private JPanel eastPanel;
    private LinkedTotalTable totalsTable;
    private DateTimeRangePanel datePanel = null;
    private JSplitPane splitter;
    private StockGroupTreePanel treePanel = null;
    private SelectQuery query;
    private GroupedTable groupedTable;
    private JCheckBox groupedCheck;
    private StockUsageReportSearcher searcher = new StockUsageReportSearcher();
    private QueryTable table;
    private QueryTableModel tableModel;
    private JComboBox areasCombo;
    private boolean alreadySetup = false;
    private boolean updatesAllowed = true;

    public StockUsageState() {
        super("Stock Usage", AllPermissions.ACCESS_STOCK_USAGE_REPORT, "Show stock usage over a time period");
        this.innerPanel = new JPanel(new BorderLayout());
        this.setScreenPanel(this.innerPanel);
    }

    @Override
    protected void onStart() {
        GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Loading Usage Report screen...");
        if (!this.alreadySetup) {
            this.alreadySetup = Dialogs.showProgressDialog((AbstractTask)new StockUsageSetupTask());
            if (!this.alreadySetup) {
                Dialogs.showErrorDialog("Error Loading Screen", "Please contact OrderMate Support");
                return;
            }
        } else {
            this.refresh();
        }
        GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
    }

    @Override
    protected void onEnd() {
    }

    private void setupGUI() {
        this.splitter = new JSplitPane();
        this.innerPanel.add((Component)this.splitter, "Center");
        this.eastPanel = new JPanel(new BorderLayout());
        this.northPanel = new JPanel(new BorderLayout());
        this.northWestPanel = new JPanel(new FlowLayout());
        this.tablePanel = new JPanel(new BorderLayout());
        JPanel addRemoveWrapper = new JPanel(new BorderLayout());
        this.eastPanel.add((Component)this.tablePanel, "Center");
        this.eastPanel.add((Component)addRemoveWrapper, "East");
        this.splitter.setRightComponent(this.eastPanel);
        this.northPanel.add((Component)this.northWestPanel, "West");
        this.innerPanel.add((Component)this.northPanel, "North");
    }

    private void setupTotalsPanel() {
        if (this.tablePanel != null && this.totalsTable != null) {
            this.tablePanel.remove(this.totalsTable);
        }
        this.totalsTable = new LinkedTotalTable(this.getActiveTable().getColumnModel());
        this.tablePanel.add((Component)this.totalsTable, "South");
        Number[] totals = this.tableModel.getTotals();
        this.totalsTable.setColumnValues(this.getCorrectTotals(totals));
    }

    private Number[] getCorrectTotals(Number[] theNormalTotals) {
        Number[] normalTotals = theNormalTotals;
        if (this.searcher.isGrouped()) {
            int titleColumn = this.tableModel.findColumn("Group");
            Number[] newTotals = new Number[normalTotals.length - 1];
            int write = 0;
            for (int read = 0; read < normalTotals.length; ++read) {
                if (read == titleColumn) continue;
                newTotals[write++] = normalTotals[read];
            }
            normalTotals = newTotals;
        }
        return normalTotals;
    }

    private void setupAreasCombo() {
        this.areasCombo = new JComboBox<Object>(StockArea.getStockAreas().toArray());
        this.areasCombo.setName("areas");
        this.areasCombo.insertItemAt("(All)", 0);
        this.areasCombo.setSelectedIndex(0);
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.areasCombo);
        this.areasCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StockUsageState.this.updatesAllowed) {
                    StockUsageState.this.refresh();
                }
            }
        });
        this.northWestPanel.add(new JLabel("Areas: "));
        this.northWestPanel.add(this.areasCombo);
    }

    private void setupDates() {
        this.datePanel = new DateTimeRangePanel();
        this.datePanel.datesChanged.connect((Object)this, "gotDatesChanged");
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        Date startOfMonth = new Date(cal.getTimeInMillis());
        cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        Date endOfToday = new Date(cal.getTimeInMillis());
        this.datePanel.setStartDate(startOfMonth);
        this.datePanel.setEndDate(endOfToday);
        this.northPanel.add((Component)this.datePanel, "East");
    }

    private void setupGroupCheck() {
        this.groupedCheck = new JCheckBox("Group results", this.searcher.isGrouped());
        this.northWestPanel.add(this.groupedCheck);
        this.groupedCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockUsageState.this.searcher.getGroupedFilter().setSearchValue((Object)StockUsageState.this.groupedCheck.isSelected());
                StockUsageState.this.refresh();
            }
        });
    }

    private void setupTree() {
        this.treePanel = new StockGroupTreePanel(((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager());
        this.treePanel.objectSelected.connect((Object)this, "gotTreeObjectSelected");
        this.splitter.setLeftComponent(this.treePanel);
    }

    private void setupTable() {
        this.tableModel = new StockUsageTableModel(this.query, "stock_item.ID", StockUsageReportQuery.dbColumns, StockUsageReportQuery.displayColumns, GuiApp.getAppComplex().getApplicationContext());
        this.tableModel.addTotalColumn("UsageCost");
        this.table = new QueryTable(this.tableModel);
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup(this.table);
        this.table.setCellRendererForAll(new StockUsageCellRenderer());
        this.tablePanel.add((Component)this.table.getScroller(), "Center");
        this.splitter.setDividerLocation(160);
    }

    public JTable getActiveTable() {
        return this.searcher.isGrouped() ? this.groupedTable : this.table;
    }

    private GroupedTable getNewGroupedTable() {
        PriceGroupedTableModel model = new PriceGroupedTableModel((AbstractTableModel)this.table.getModel(), "Group", new String[]{StockUsageReportQuery.DISPLAYLABEL_COST});
        this.groupedTable = new GroupedTable(model);
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup((JTable)((Object)this.groupedTable));
        this.groupedTable.setCellRendererForAll(new StockUsageGroupedCellRenderer());
        return this.groupedTable;
    }

    private StockGroup getCurrentStockGroup() {
        Object obj = this.treePanel.getSelectedObject();
        return obj instanceof StockGroup ? (StockGroup)obj : null;
    }

    private StockArea getCurrentStockArea() {
        Object obj = this.areasCombo.getSelectedItem();
        return obj instanceof StockArea ? (StockArea)obj : null;
    }

    public void updateQuery(StockGroup group, StockArea area, Date start, Date end) {
        this.searcher.getGroupFilter().setSearchValue((Object)group);
        this.searcher.getAreaFilter().setSearchValue((Object)area);
        this.searcher.getDateRangeFilter().setStart((Comparable)start);
        this.searcher.getDateRangeFilter().setEnd((Comparable)end);
        this.query = this.searcher.getQuery();
        this.tableModel.setQuery(this.query);
        this.table.updateModel();
        this.table.revalidate();
        this.tablePanel.remove(this.table.getScroller());
        if (this.groupedTable != null) {
            this.tablePanel.remove(this.groupedTable.getScroller());
        }
        if (this.searcher.isGrouped()) {
            this.tablePanel.add((Component)this.getNewGroupedTable().getScroller(), "Center");
        } else {
            this.tablePanel.add((Component)this.table.getScroller(), "Center");
        }
        this.setupTotalsPanel();
        this.tablePanel.revalidate();
        this.tablePanel.repaint();
    }

    @Override
    public boolean supportsRefresh() {
        return true;
    }

    @Override
    public void doRefreshAction() {
        this.refresh();
    }

    @Override
    public void refresh() {
        this.updatesAllowed = false;
        if (this.treePanel == null) {
            this.updatesAllowed = true;
            return;
        }
        Object selGroup = this.treePanel.getSelectedObject();
        this.treePanel.refresh();
        this.treePanel.getTree().setSelectedObject(selGroup);
        Object comboSelected = this.areasCombo.getSelectedItem();
        this.areasCombo.setModel(new DefaultComboBoxModel<Object>(StockArea.getStockAreas().toArray()));
        this.areasCombo.insertItemAt("(All)", 0);
        this.areasCombo.setSelectedIndex(0);
        this.areasCombo.setSelectedItem(comboSelected);
        boolean groupResults = this.searcher.isGrouped();
        Long selectedID = OfficeMateAdminGuiUtils.getInstance().getSelectedID(this.table, groupResults ? this.groupedTable : null);
        int selectedTableRow = OfficeMateAdminGuiUtils.getInstance().getSelectedTableRow(this.table, groupResults ? this.groupedTable : null);
        this.updateQuery(this.getCurrentStockGroup(), this.getCurrentStockArea(), this.datePanel.getStartDate(), this.datePanel.getEndDate());
        OfficeMateAdminGuiUtils.getInstance().selectIfPossible(this.table, groupResults ? this.groupedTable : null, selectedID, selectedTableRow);
        this.updatesAllowed = true;
    }

    @Override
    public boolean supportsSearch() {
        return true;
    }

    @Override
    public void doSearchAction() {
        StockItemSearchPanel searchPanel = new StockItemSearchPanel();
        Long id = SearchDialog.search(GuiApp.getAppComplex().getApplicationFrame().getFrame(), searchPanel, "Find Stock Item...");
        if (id != null) {
            JScrollPane scrollerToUse;
            Object tableToUse;
            int tableRow;
            this.treePanel.getTree().setSelectedObject(null);
            int originalRow = this.table.getQueryTableModel().getRow(id);
            if (originalRow == -1) {
                JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "This report does not contain the requested item. ", "Can't find item", 1);
                return;
            }
            if (this.searcher.isGrouped()) {
                tableRow = this.groupedTable.getGroupedTableModel().getGroupedRow(originalRow);
                this.groupedTable.setRowSelectionInterval(tableRow, tableRow);
                tableToUse = this.groupedTable;
                scrollerToUse = this.groupedTable.getScroller();
            } else {
                tableRow = originalRow;
                this.table.setRowSelectionInterval(tableRow, tableRow);
                tableToUse = this.table;
                scrollerToUse = this.table.getScroller();
            }
            GuiUtils.scrollToTableRow((JScrollPane)scrollerToUse, (JTable)tableToUse, (int)tableRow);
            ((JComponent)tableToUse).revalidate();
            ((Component)tableToUse).repaint();
        }
    }

    void gotDatesChanged(Date newStartDate, Date newEndDate) {
        if (this.datePanel != null) {
            this.updateQuery(this.getCurrentStockGroup(), this.getCurrentStockArea(), newStartDate, newEndDate);
        }
    }

    @Override
    public boolean supportsPrint() {
        return true;
    }

    @Override
    public void doPrintAction() {
        StockArea area = this.getCurrentStockArea();
        StockGroup group = this.getCurrentStockGroup();
        String groupString = group != null ? " Group: " + group.toString() : "";
        String areaString = area != null ? " Area: " + area.toString() : "";
        DateDMY coarseDate1 = new DateDMY((Date)this.datePanel.getSQLStartDate());
        DateDMY coarseDate2 = new DateDMY((Date)this.datePanel.getSQLEndDate());
        String title = "Stock Usage (from " + coarseDate1 + " to " + coarseDate2 + ")";
        Printing.printJTableReport(this.getActiveTable(), title, groupString + areaString, 8, null);
    }

    void gotTreeObjectSelected(Object obj) {
        if (this.updatesAllowed) {
            StockGroup group = null;
            if (obj instanceof StockGroup) {
                group = (StockGroup)obj;
            }
            this.updateQuery(group, this.getCurrentStockArea(), this.datePanel.getStartDate(), this.datePanel.getEndDate());
        }
    }

    public StockUsageReportSearcher getSearcher() {
        return this.searcher;
    }

    private class StockUsageSetupTask
    extends AbstractGuiTask {
        private StockUsageSetupTask() {
        }

        public String getName() {
            return "Loading SOH Report screen...";
        }

        public void doGuiTask() throws Exception {
            StockUsageState.this.setupGUI();
            this.emitProgress();
            StockUsageState.this.setupAreasCombo();
            this.emitProgress();
            StockUsageState.this.setupGroupCheck();
            this.emitProgress();
            StockUsageState.this.setupTree();
            this.emitProgress();
            StockUsageState.this.setupTable();
            this.emitProgress();
            StockUsageState.this.setupDates();
            this.emitProgress();
            StockUsageState.this.refresh();
            StockUsageState.this.alreadySetup = true;
            this.emitProgress();
        }

        public int getTotalSubTasks() {
            return 7;
        }
    }
}

