/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.vouchers.summary;

import au.com.ordermate.application.ApplicationNavigator;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.search.pager.Pager;
import au.com.ordermate.search.pager.PagerModel;
import au.com.ordermate.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellRenderer;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.table.TotalsTableModelBuilder;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.reports.vouchers.audit.VoucherAuditCompositeState;
import officemate.screens.reports.vouchers.summary.VoucherSearch;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.searchers.reports.vouchers.VoucherSearcher;
import ordermate.database.users.AllPermissions;
import ordermate.integration.voucher.VoucherAdministratorRMI;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jfree.ui.DateCellRenderer;

public class VoucherState
extends AbstractTableState<GiftVoucher> {
    private static final int PAGE_RESULTS = 1000;
    private AbstractAction fetchVoucherButton;
    private PagerModel pager = new PagerModel(1000);

    public VoucherState() {
        super("Voucher Summary", AllPermissions.CONFIG_GIFT_VOUCHERS, "View all vouchers for your store, filtering by customer or voucher number.");
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.fetchVoucherButton = new AbstractAction("Fetch Voucher..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                String input = JOptionPane.showInputDialog("Unique ID", (Object)"");
                if (input != null) {
                    GiftVoucher voucher = VoucherAdministratorRMI.getInstance().getVoucher(input);
                    if (voucher == null) {
                        Dialogs.showInfoDialog("Retrieved " + input, "Voucher found: " + voucher.getSystemState() + " cached value: " + voucher.getCachedValue());
                    } else {
                        Dialogs.showInfoDialog("Cannot retreive " + input, "Cannot retrieve voucher.");
                    }
                }
            }
        };
        this.addAction(this.fetchVoucherButton);
        this.addPageControl(this.pager);
    }

    @Override
    protected TableStateCentralArea<GiftVoucher> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(GiftVoucher.Properties.UNIQUE_ID), new PropertyColumnFormat(GiftVoucher.Properties.CUSTOMER), this.createCreationDateTimeFormat(), VoucherState.createLastActiveDateTimeFormat(), new PropertyColumnFormat("Charge Left", GiftVoucher.Properties.CACHED_VALUE), new PropertyColumnFormat(GiftVoucher.Properties.SYSTEM_STATE)});
        PersistentObjectTable<GiftVoucher> table = new PersistentObjectTable<GiftVoucher>(this.getObjectList(), format);
        TotalsTableModelBuilder ttmb = new TotalsTableModelBuilder("Unique Id", "Customer", "Date Created", "Last Active", "System State");
        table.setTotalsBuilder(ttmb);
        return table;
    }

    @Override
    protected Class<GiftVoucher> getDisplayingType() {
        return GiftVoucher.class;
    }

    @Override
    public OfficeMateObjectSearch<GiftVoucher> createSearchPanelFactory() {
        VoucherSearch searcher = new VoucherSearch();
        searcher.usePagedObjectQueryRefreshStrategy((Pager)this.pager);
        return searcher;
    }

    @Override
    public void gotObjectDoubleClicked(GiftVoucher toEdit) {
        ApplicationNavigator nav = GuiApp.getAppComplex().getApplicationNavigator();
        nav.navigateTo("Voucher Audit");
        ((VoucherAuditCompositeState)nav.getState("Voucher Audit")).setVoucher(toEdit);
    }

    private AbstractColumnFormat createCreationDateTimeFormat() {
        return new AbstractColumnFormat("Date Created", GiftVoucher.class){

            public Object resolveColumnValue(Object baseObject) {
                GiftVoucher gv = (GiftVoucher)baseObject;
                return DateTimeUtils.combineDateAndTime((Date)gv.getCreationDate(), (Date)gv.getCreationTime());
            }

            public TableCellRenderer getCustomRenderer() {
                return new DateCellRenderer(DateTimeUtils.getDateTimeFormat());
            }
        };
    }

    private static AbstractColumnFormat createLastActiveDateTimeFormat() {
        return new AbstractColumnFormat("Last Active", GiftVoucher.class){

            public Object resolveColumnValue(Object baseObject) {
                GiftVoucher gv = (GiftVoucher)baseObject;
                Date latest = null;
                for (GiftVoucherTransaction gvt : gv.getTransactions()) {
                    Date current = DateTimeUtils.combineDateAndTime((Date)gvt.getCreationDate(), (Date)gvt.getCreationTime());
                    if (latest == null || !current.after(latest)) continue;
                    latest = current;
                }
                return latest == null ? null : DateTimeUtils.getDateTimeFormat().format(latest);
            }
        };
    }

    public VoucherSearcher getSearcher() {
        this.init();
        return ((VoucherSearch)this.getSearchFactory()).getSearcher();
    }
}

