/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.vouchers.transactions;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import officemate.components.search.ObjectPropertySearch;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.misc.TradingDay;
import ordermate.database.searchers.reports.vouchers.VoucherTransactionSearcher;

public class VoucherTransactionSearchPanel
extends ObjectPropertySearch<GiftVoucherTransaction> {
    private VoucherTransactionSearcher searcher;
    private EventList<TradingDay> tradingDays;

    public VoucherTransactionSearchPanel() {
        super(GiftVoucherTransaction.class);
        RefreshAction refresh = new RefreshAction((Refreshable)this);
        this.getSearcher();
        this.loadTradingDays();
        this.addSearchField((SearchGuiField)new StringSearchField("Voucher Code", this.searcher.getUuidPrefixFilter(), (Action)refresh));
        this.addSearchField((SearchGuiField)new StringSearchField("First Name", this.searcher.getFirstNameFilter(), (Action)refresh));
        this.addSearchField((SearchGuiField)new StringSearchField("Last Name", this.searcher.getLastNameFilter(), (Action)refresh));
        this.addSearchField((SearchGuiField)new ComboSearchField("Trading Day", (ISingleValueSearchFilter)this.searcher.getTradingDayFilter(), false, (Action)refresh, this.tradingDays));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Sales Location", this.searcher.getSalesLocationFilter(), (Action)refresh, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations())));
    }

    private void loadTradingDays() {
        this.tradingDays = new BasicEventList();
        this.tradingDays.addAll((Collection)TradingDay.getAllTradingDays());
        Collections.reverse(this.tradingDays);
    }

    @Override
    protected ObjectQuerySearcher<GiftVoucherTransaction> constructPropertySearcher() {
        return new VoucherTransactionSearcher();
    }

    @Override
    public void reaquireSearchOptions() {
        this.tradingDays.clear();
        ArrayList allDays = new ArrayList(TradingDay.getAllTradingDays());
        Collections.reverse(allDays);
        this.tradingDays.addAll(allDays);
    }

    public VoucherTransactionSearcher getSearcher() {
        this.searcher = (VoucherTransactionSearcher)this.getPropertySearcher();
        return this.searcher;
    }
}

