/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.vouchers.transactions;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.search.pager.Pager;
import au.com.ordermate.search.pager.PagerModel;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.reports.vouchers.transactions.VoucherTransactionSearchPanel;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.sales.Customer;
import ordermate.database.searchers.reports.vouchers.VoucherTransactionSearcher;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class VoucherTransactionState
extends AbstractTableState<GiftVoucherTransaction> {
    private static final int PAGE_RESULTS = 1000;
    private PagerModel pager = new PagerModel(1000);

    public VoucherTransactionState() {
        super("Transactions", AllPermissions.CONFIG_GIFT_VOUCHERS, "View gift vouchers transactions");
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.addPageControl(this.pager);
    }

    @Override
    protected TableStateCentralArea<GiftVoucherTransaction> createCentralArea() {
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(GiftVoucherTransaction.Properties.TRADING_DAY), new PropertyColumnFormat("Voucher Details", (PropertyAccessor)GiftVoucherTransaction.Properties.GIFT_VOUCHER, (Format)new GiftVoucherFormat()), new PropertyColumnFormat("Transaction Type", (PropertiedObject.Property)GiftVoucherTransaction.Properties.VOUCHER_TRANSACTION_TYPE), new PropertyColumnFormat(GiftVoucherTransaction.Properties.AMOUNT), new PropertyColumnFormat(GiftVoucherTransaction.Properties.AUTH_ID), new PropertyColumnFormat(GiftVoucherTransaction.Properties.SYSTEM_STATE), new PropertyColumnFormat(GiftVoucherTransaction.Properties.EXPIRY_DATE), new PropertyColumnFormat(GiftVoucherTransaction.Properties.EXPIRY_TIME, (Format)timeFormat)});
        PersistentObjectTable<GiftVoucherTransaction> table = new PersistentObjectTable<GiftVoucherTransaction>(this.getObjectList(), format);
        return table;
    }

    @Override
    protected Class<GiftVoucherTransaction> getDisplayingType() {
        return GiftVoucherTransaction.class;
    }

    @Override
    public OfficeMateObjectSearch<GiftVoucherTransaction> createSearchPanelFactory() {
        VoucherTransactionSearchPanel searcher = new VoucherTransactionSearchPanel();
        searcher.usePagedObjectQueryRefreshStrategy((Pager)this.pager);
        return searcher;
    }

    public VoucherTransactionSearcher getSearcher() {
        this.init();
        return ((VoucherTransactionSearchPanel)this.getSearchFactory()).getSearcher();
    }

    class GiftVoucherCustomerFormat
    extends Format {
        GiftVoucherCustomerFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendToCustomer, FieldPosition pos) {
            Customer customer = ((GiftVoucher)obj).getCustomer();
            if (customer != null) {
                toAppendToCustomer.append(customer.getFirstName());
                toAppendToCustomer.append(" ");
                toAppendToCustomer.append(customer.getLastName() == null ? "" : customer.getLastName());
            }
            return toAppendToCustomer;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return null;
        }
    }

    class GiftVoucherFormat
    extends Format {
        GiftVoucherFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            toAppendTo.append("Voucher ID: ").append(((GiftVoucher)obj).getUniqueId());
            Customer customer = ((GiftVoucher)obj).getCustomer();
            if (customer != null) {
                toAppendTo.append(" for: ");
                toAppendTo.append(customer.getFirstName());
                toAppendTo.append(" ");
                toAppendTo.append(customer.getLastName() == null ? "" : customer.getLastName());
            }
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return null;
        }
    }
}

