/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.accounting;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.persistence.PropertiedObject;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import officemate.adminkit.dialogs.OfficeMateGuiHandler;
import officemate.components.AbstractObjectEditor;
import officemate.screens.setup.configuration.webservice.TrackingCategoryEditor;
import officemate.screens.setup.configuration.webservice.WebserviceConfigSetupEditor;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.AccountingIntegrationExportFrequency;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.database.schedule.Schedule;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import ordermate.integration.finance.myob.mapping.FinanceExportStyle;
import ordermate.integration.oauth.OAuth2Client;
import ordermate.integration.oauth.OAuth2ClientHandler;
import ordermate.integration.oauth.XeroOAuth2Handler;
import org.jdesktop.beansbinding.Validator;
import org.jdesktop.swingx.JXDatePicker;

class AccountingConfigurationEditor
extends AbstractObjectEditor<AccountingIntegrationConfig>
implements ActionListener,
ItemListener {
    private JComboBox integrationType;
    private JComboBox apiVersion;
    private JCheckBox exportSales;
    private JCheckBox exportData;
    private JComboBox exportFrequency;
    private WebserviceConfigSetupEditor webserviceSetupEditor;
    private TrackingCategoryEditor trackingCategoryEditor;
    private JXDatePicker lastExportDate;
    private JTextField salesInvoiceCustomer;
    private EventList<String> apiVersionList;

    public AccountingConfigurationEditor() {
        this.setLayout(new FlowLayout(0));
    }

    private boolean listenerExists(ItemListener[] arr) {
        for (ItemListener i : arr) {
            if (i != this) continue;
            return true;
        }
        return false;
    }

    public void addListener() {
        if (!this.listenerExists(this.exportFrequency.getItemListeners())) {
            this.exportFrequency.addItemListener(this);
        }
    }

    @Override
    protected void init() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.integrationType = this.setupComboBox(AccountingIntegrationConfig.Properties.TYPE, new DefaultComboBoxModel<Object>(FinanceExportStyle.getMap().values().toArray()), (Validator)new NotEmptyValidator());
        this.integrationType.addActionListener(this);
        builder.addRow("Accounting Package:", (Component)this.integrationType);
        this.apiVersionList = GlazedLists.eventList((Collection)((FinanceExportStyle)this.integrationType.getSelectedItem()).getApiVersions());
        this.apiVersion = this.setupComboBox(AccountingIntegrationConfig.Properties.API_VERSION, (ComboBoxModel)new EventComboBoxModel(this.apiVersionList), (Validator)new NotEmptyValidator());
        builder.addRow("API Version:", (Component)this.apiVersion);
        this.exportSales = this.setupCheckBox(AccountingIntegrationConfig.Properties.EXPORT_SALES_DATA);
        builder.addRow("Export Sales Data:", (Component)this.exportSales);
        this.exportData = this.setupCheckBox(AccountingIntegrationConfig.Properties.EXPORT_STOCK_DATA);
        builder.addRow("Export Stock Data:", (Component)this.exportData);
        this.lastExportDate = this.setupDatePicker(AccountingIntegrationConfig.Properties.LAST_EXPORT_DATE);
        builder.addRow("Last Export Date:", (Component)this.lastExportDate);
        this.exportFrequency = this.setupComboBox(AccountingIntegrationConfig.Properties.EXPORT_FREQUENCY, new DefaultComboBoxModel<Object>(AccountingIntegrationExportFrequency.getRegister().values().toArray()), (Validator)new NotEmptyValidator());
        builder.addRow("Export Frequency:", (Component)this.exportFrequency);
        this.salesInvoiceCustomer = this.setupTextField(AccountingIntegrationConfig.Properties.SALES_INV_CUSTOMER, 20);
        builder.addRow("Sales Inv Customer", (Component)this.salesInvoiceCustomer);
        this.webserviceSetupEditor = new WebserviceConfigSetupEditor(builder, this.getListener(), this.getBindings(), (PropertiedObject.Property<WebserviceIntegrationConfig>)AccountingIntegrationConfig.Properties.WEBSERVICE_CONFIG);
        builder.addRow("Export Prefix", (Component)this.setupTextField(AccountingIntegrationConfig.Properties.EXPORT_PREFIX, 20));
        builder.addRow("Retry Days", (Component)this.setupTextField(AccountingIntegrationConfig.Properties.RETRY_DAYS, 20));
        this.trackingCategoryEditor = new TrackingCategoryEditor();
        this.trackingCategoryEditor.changeSignal.connect((Object)this, "gotTrackingEditorChanged");
        builder.addRow((Component)this.trackingCategoryEditor);
        this.add(builder.getPanel());
    }

    private void gotTrackingEditorChanged() {
        this.objectEdited.emit();
    }

    @Override
    public void setObject(AccountingIntegrationConfig toEdit) {
        if (toEdit.getWebserviceConfig() == null) {
            toEdit.setWebserviceConfig(new WebserviceIntegrationConfig());
        }
        super.setObject(toEdit);
    }

    private void setupComponentsForType(FinanceExportStyle type) {
        boolean advancedOptions = FinanceExportStyle.Xero.equals((Object)type);
        this.exportFrequency.setEnabled(advancedOptions);
        this.lastExportDate.setEnabled(advancedOptions);
        this.salesInvoiceCustomer.setEnabled(advancedOptions);
        if (this.webserviceSetupEditor != null) {
            if (FinanceExportStyle.Xero.equals((Object)type)) {
                OAuth2Client client = new OAuth2Client(((AccountingIntegrationConfig)this.getObject()).getWebserviceConfig(), (OAuth2ClientHandler)new XeroOAuth2Handler(), (GuiHandler)new OfficeMateGuiHandler());
                this.webserviceSetupEditor.setOAuth2Client(client);
                this.webserviceSetupEditor.setType(type);
                this.doDefaults();
                this.trackingCategoryEditor.setEnabled(true);
            } else {
                this.trackingCategoryEditor.setEnabled(false);
                this.webserviceSetupEditor.setType(null);
            }
            this.webserviceSetupEditor.setAllCompsEnabled(advancedOptions);
        }
        GlazedListUtils.setAsList(this.apiVersionList, (Collection)((FinanceExportStyle)this.integrationType.getSelectedItem()).getApiVersions());
        if (this.apiVersion.getSelectedItem() == null || !this.apiVersionList.contains(this.apiVersion.getSelectedItem())) {
            this.apiVersion.setSelectedIndex(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.integrationType)) {
            this.setupComponentsForType((FinanceExportStyle)this.integrationType.getSelectedItem());
        }
    }

    private void doDefaults() {
        WebserviceIntegrationConfig webConfig = ((AccountingIntegrationConfig)this.getObject()).getWebserviceConfig();
        FinanceExportStyle type = (FinanceExportStyle)this.integrationType.getSelectedItem();
        if (FinanceExportStyle.Xero.equals((Object)type) && webConfig.getClientId() == null) {
            webConfig.setClientId("1E0648BF5D5F4548B3AE00DE0F07BF3A");
            webConfig.setClientSecret("rTRQJuBN4VBv54VPLf-z0FZHGTOtGH0GPbkN5K3DQM6lZsW5");
            webConfig.setUrl("https://api.xero.com/api.xro/2.0/");
            this.webserviceSetupEditor.setObject(webConfig);
        }
    }

    @Override
    public void saveObject() {
        super.saveObject();
        this.trackingCategoryEditor.save();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this.exportFrequency) && e.getStateChange() == 1 && AccountingIntegrationExportFrequency.Custom.equals(this.exportFrequency.getSelectedItem())) {
            String recurrence;
            Schedule accSchedule = Schedule.findByLabel((String)"Accounting Integration Export Task");
            if (accSchedule == null) {
                accSchedule = new Schedule();
                accSchedule.setTask("Accounting Integration Export Task");
                accSchedule.setLabel("Accounting Integration Export Task");
            }
            if ((recurrence = JOptionPane.showInputDialog("Please enter a recurrence:", (Object)"")) != null) {
                accSchedule.setRecurrence(recurrence);
                accSchedule.setSystemState(SystemState.ACTIVE_STATE);
                accSchedule.save();
            }
        }
    }
}

