/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.accounting;

import au.com.ordermate.guicore.Refreshable;
import officemate.components.AbstractObjectEditor;
import officemate.components.ObjectEditorState;
import officemate.components.strategy.SaveStrategy;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.strategy.StrategySaveCancelListener;
import officemate.screens.setup.configuration.accounting.AccountingConfigurationEditor;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.users.AllPermissions;

public class AccountingConfigurationState
extends ObjectEditorState<AccountingIntegrationConfig>
implements StrategySaveCancelListener {
    private SaveStrategy saveStrategy = SaveStrategyFactory.getDeferredSaveStrategy((Refreshable)this);
    private AccountingConfigurationEditor editor;

    public AccountingConfigurationState() {
        super("Accounting Integration", AllPermissions.CONFIG_INTEGRATIONS, "Allows configuring the accounting integration setup.");
        this.saveStrategy.addSaveCancelListener(this);
        this.setSaveStrategy(this.saveStrategy);
    }

    @Override
    protected AccountingIntegrationConfig acquireObject() {
        return AccountingIntegrationConfig.getInstance();
    }

    @Override
    protected AbstractObjectEditor<AccountingIntegrationConfig> createObjectEditor() {
        this.editor = new AccountingConfigurationEditor();
        return this.editor;
    }

    @Override
    public void onStart() {
        super.onStart();
        this.editor.addListener();
    }

    @Override
    public void preSave() {
        this.getObjectEditor().saveObject();
    }

    @Override
    public void preCancel() {
        this.getObjectEditor().revertObject();
    }

    @Override
    public void postSave() {
    }

    @Override
    protected void setObjectToEdit(AccountingIntegrationConfig obj) {
        super.setObjectToEdit(obj);
        this.saveStrategy.clear();
    }

    @Override
    protected void onEnd() {
        if (this.saveStrategy.isChanged()) {
            this.saveStrategy.promptForSave(this.getScreenPanel());
        }
        super.onEnd();
    }
}

