/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.accounting;

import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.List;
import officemate.screens.setup.configuration.accounting.GLAccountQueryBuilder;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.InventoryGroupToLocationAccLink;
import ordermate.database.integration.accounting.settings.BaseAccountingConfiguration;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.integration.giftvoucher.GiftVoucherConfiguration;
import ordermate.database.integration.giftvoucher.GiftVoucherConfigurationGLAccountLink;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockAreaGlLink;
import ordermate.database.stock.StockGroup;
import ordermate.reports.accounting.GLCodeLinkReport;

public class GLAccountLinkQueries {
    public static final String EXPORT_TYPE = "type";
    public static final String DESCRIPTION = "description";
    public static final String GL_CODE = "gl_code";
    public static final String FK_LINK = "fk_link";
    public static final int IDX_EXPORT_TYPE = 0;
    public static final int IDX_DESCRIPTION = 1;
    public static final int IDX_GL_CODE = 2;
    public static final int IDX_FK_LINK = 3;
    private static final String UNION_STR = " UNION ";

    public static List<GLCodeLinkReport> getAllGLAccountLinks() {
        ArrayList<GLCodeLinkReport> results = new ArrayList<GLCodeLinkReport>();
        if (AccountingIntegrationConfig.getInstance().isGroupBySalesLocation()) {
            results.addAll(GLAccountLinkQueries.getReports(GLAccountLinkQueries.getSalesIncomeGLAccountLinksGroupedTermLocation()));
        } else {
            results.addAll(GLAccountLinkQueries.getReports(GLAccountLinkQueries.getSalesIncomeGLAccountLinks()));
        }
        results.addAll(GLAccountLinkQueries.getReports(GLAccountLinkQueries.getCustomerAccountsGLAccountLinks()));
        results.addAll(GLAccountLinkQueries.getReports(GLAccountLinkQueries.getTakingsGLAccountLinks()));
        results.addAll(GLAccountLinkQueries.getReports(GLAccountLinkQueries.getReconciliationGLAccountLinks()));
        results.addAll(GLAccountLinkQueries.getReports(GLAccountLinkQueries.getPriceAdjustmentsGLAccountLinks()));
        results.addAll(GLAccountLinkQueries.getReports(GLAccountLinkQueries.getTradeDebtorsGLAccountLinks()));
        results.addAll(GLAccountLinkQueries.getReports(GLAccountLinkQueries.getInvoiceGLAccountLinks()));
        results.addAll(GLAccountLinkQueries.getReports(GLAccountLinkQueries.getMovementsByStockAreaGLAccountLinks()));
        results.addAll(GLAccountLinkQueries.getReports(GLAccountLinkQueries.getGiftVoucherGLAccountLinks()));
        return results;
    }

    private static List<GLCodeLinkReport> getReports(String sql) {
        return PersistenceManager.getObjectList(GLCodeLinkReport.class, (String)sql);
    }

    private static String getSalesIncomeGLAccountLinks() {
        return new GLAccountQueryBuilder().select(GLCodeLinkReport.Properties.EXPORT_TYPE, "'SALES_INCOME'").select(GLCodeLinkReport.Properties.DESCRIPTION, "inventory_group.name").select(GLCodeLinkReport.Properties.INVENTORY_GROUP, "inventory_group.ID").select(GLCodeLinkReport.Properties.GL_ACCOUNT, "config_integration_acc_gl_account.ID").from("inventory_group").join(GLAccount.class, InventoryGroup.Properties.GL_ACCOUNT).where("system_state = 'ACTIVE'").union(GLAccountLinkQueries.getDefaultAccountLinks("SALES_INCOME", "Default Sales Income GL Code")).build();
    }

    private static String getSalesIncomeGLAccountLinksGroupedTermLocation() {
        return new GLAccountQueryBuilder().select(GLCodeLinkReport.Properties.EXPORT_TYPE, "'SALES_INCOME'").select(GLCodeLinkReport.Properties.DESCRIPTION, "inventory_group.name").select(GLCodeLinkReport.Properties.INVENTORY_GROUP, "inventory_group.ID").select(GLCodeLinkReport.Properties.GL_ACCOUNT, "config_integration_acc_group_location_link.fk_config_integration_acc_gl_account").select(GLCodeLinkReport.Properties.SALES_LOCATION, "config_integration_acc_group_location_link.fk_config_sales_location").from("inventory_group").join(GLAccount.class, InventoryGroup.Properties.GL_ACCOUNT).join(InventoryGroupToLocationAccLink.class, InventoryGroupToLocationAccLink.Properties.INVENTORY_GROUP).where("system_state = 'ACTIVE'").union(GLAccountLinkQueries.getDefaultAccountLinks("SALES_INCOME", "Default Sales Income GL Code")).build();
    }

    private static String getCustomerAccountsGLAccountLinks() {
        return GLAccountLinkQueries.getDefaultAccountLinks("CUSTOMER_ACCOUNTS", "Customer Account GL Code");
    }

    private static String getTakingsGLAccountLinks() {
        return new GLAccountQueryBuilder().select(GLCodeLinkReport.Properties.EXPORT_TYPE, "'TAKINGS'").select(GLCodeLinkReport.Properties.DESCRIPTION, "finance_accounting_group.name").select(GLCodeLinkReport.Properties.GL_ACCOUNT, "config_integration_acc_gl_account.ID").select(GLCodeLinkReport.Properties.FINANCE_ACCOUNTING_GROUP, "finance_accounting_group.ID").from("finance_accounting_group").join("LEFT JOIN config_integration_acc_gl_account ON finance_accounting_group.fk_config_integration_acc_gl_account = config_integration_acc_gl_account.ID ").union(GLAccountLinkQueries.getDefaultAccountLinks("TAKINGS", "Default Finance GL Code")).build();
    }

    private static String getReconciliationGLAccountLinks() {
        return GLAccountLinkQueries.getDefaultAccountLinks("RECONCILIATION", "Reconciliation", "Petty Cash");
    }

    private static String getPriceAdjustmentsGLAccountLinks() {
        return GLAccountLinkQueries.getDefaultAccountLinks("PRICE_ADJUSTMENTS", "Default Discount Cogs GL Code", "Default Sales Surcharge GL Code", "Balance Adjustment GL Code");
    }

    private static String getTradeDebtorsGLAccountLinks() {
        return GLAccountLinkQueries.getDefaultAccountLinks("TRADE_DEBTORS", "Default Debtor GL Code");
    }

    private static String getGiftVoucherGLAccountLinks() {
        return new GLAccountQueryBuilder().select(GLCodeLinkReport.Properties.EXPORT_TYPE, "'LIABILITIES'").select(GLCodeLinkReport.Properties.DESCRIPTION, "CONCAT(config_gift_voucher.label, ' ', " + GLAccountLinkQueries.titleCase("config_gift_voucher_gl_link.transaction_type") + ", ' GL Code')").select(GLCodeLinkReport.Properties.GL_ACCOUNT, "config_gift_voucher_gl_link.fk_gl_account").select(GLCodeLinkReport.Properties.VOUCHER_LINK, "config_gift_voucher_gl_link.ID").from("config_gift_voucher_gl_link").join(GiftVoucherConfiguration.class, GiftVoucherConfigurationGLAccountLink.Properties.GIFT_VOUCHER_CONFIG).join(GLAccount.class, GiftVoucherConfigurationGLAccountLink.Properties.GL_ACCOUNT).union(GLAccountLinkQueries.getDefaultAccountLinks("LIABILITIES", "Default Gift Voucher Topup GL Code", "Default Gift Voucher Redeem GL Code")).build();
    }

    private static String titleCase(String value) {
        return "CONCAT(UPPER(SUBSTR(" + value + ", 1, 1)), LOWER(SUBSTR(" + value + ", 2)))";
    }

    private static String getInvoiceGLAccountLinks() {
        switch (BaseAccountingConfiguration.getInstance().getInvoiceGLGroup()) {
            case None: {
                return GLAccountLinkQueries.getInvoiceByDefaultGLAccountLinks();
            }
            case StockGroup: {
                return GLAccountLinkQueries.getInvoiceByStockGroupGLAccountLinks() + UNION_STR + GLAccountLinkQueries.getInvoiceByDefaultGLAccountLinks();
            }
            case StockArea: {
                return GLAccountLinkQueries.getInvoiceByStockAreaGLAccountLinks() + UNION_STR + GLAccountLinkQueries.getInvoiceByDefaultGLAccountLinks();
            }
        }
        return GLAccountLinkQueries.getInvoiceByDefaultGLAccountLinks();
    }

    private static String getInvoiceByStockAreaGLAccountLinks() {
        return new GLAccountQueryBuilder().select(GLCodeLinkReport.Properties.EXPORT_TYPE, "'INVOICES'").select(GLCodeLinkReport.Properties.DESCRIPTION, "stock_area.name").select(GLCodeLinkReport.Properties.GL_ACCOUNT, "config_integration_acc_gl_account.ID").select(GLCodeLinkReport.Properties.STOCK_AREA, "stock_area.ID").from("stock_area").join(GLAccount.class, StockArea.Properties.GL_CODE).where("system_state = 'ACTIVE'").build();
    }

    private static String getInvoiceByStockGroupGLAccountLinks() {
        return new GLAccountQueryBuilder().select(GLCodeLinkReport.Properties.EXPORT_TYPE, "'INVOICES'").select(GLCodeLinkReport.Properties.DESCRIPTION, "stock_group.name").select(GLCodeLinkReport.Properties.GL_ACCOUNT, "config_integration_acc_gl_account.ID").select(GLCodeLinkReport.Properties.STOCK_GROUP, "stock_group.ID").from("stock_group").join(GLAccount.class, StockGroup.Properties.GL_CODE).where("system_state = 'ACTIVE'").build();
    }

    private static String getInvoiceByDefaultGLAccountLinks() {
        return GLAccountLinkQueries.getDefaultAccountLinks("INVOICES", "Default Invoice GL Code");
    }

    private static String getMovementsByStockAreaGLAccountLinks() {
        return new GLAccountQueryBuilder().select(GLCodeLinkReport.Properties.EXPORT_TYPE, "'STOCK_MOVEMENTS'").select(GLCodeLinkReport.Properties.DESCRIPTION, "CONCAT(stock_area.name, ' ' , stock_area_gl_link.gl_type)").select(GLCodeLinkReport.Properties.GL_ACCOUNT, "config_integration_acc_gl_account.ID").select(GLCodeLinkReport.Properties.STOCK_AREA, "stock_area.ID").select(GLCodeLinkReport.Properties.GL_TYPE, "stock_area_gl_link.gl_type").from("stock_area").join(StockAreaGlLink.class, StockAreaGlLink.Properties.STOCK_AREA).join(GLAccount.class, StockAreaGlLink.Properties.GL_ACCOUNT).where("stock_area.system_state = 'ACTIVE'").build();
    }

    private static String getDefaultAccountLinks(String exportType, String ... namesLike) {
        GLAccountQueryBuilder builder = new GLAccountQueryBuilder();
        builder.select(GLCodeLinkReport.Properties.EXPORT_TYPE, "'" + exportType + "'").select(GLCodeLinkReport.Properties.DESCRIPTION, "config_integration_acc_settings.name").select(GLCodeLinkReport.Properties.GL_ACCOUNT, "config_integration_acc_gl_account.ID").from("config_integration_acc_settings").join("LEFT JOIN config_integration_acc_gl_account ON config_integration_acc_settings.value = config_integration_acc_gl_account.ID ");
        if (namesLike.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < namesLike.length; ++i) {
                if (i > 0) {
                    sb.append(" OR ");
                }
                sb.append("config_integration_acc_settings.name LIKE '%" + namesLike[i] + "%'");
            }
            builder.where(sb.toString());
        }
        return builder.build();
    }
}

