/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.accounting;

import au.com.ordermate.glazedlists.PropertyComparator;
import au.com.ordermate.glazedlists.SequentialComparator;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.strategy.StrategySaveCancelListener;
import officemate.screens.setup.configuration.accounting.BaseGLAccountOfficeMateState;
import officemate.screens.setup.configuration.accounting.GLAccountLinkPanel;
import officemate.screens.setup.configuration.accounting.GLAccountLinkQueries;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.InventoryGroupToLocationAccLink;
import ordermate.database.integration.accounting.settings.BaseAccountingConfiguration;
import ordermate.database.users.AllPermissions;
import ordermate.reports.accounting.GLCodeLinkReport;

public class GLAccountLinkSetupState
extends BaseGLAccountOfficeMateState
implements StrategySaveCancelListener {
    private GLAccountLinkPanel glAccountLinkPanel;
    private EventList<GLCodeLinkReport> glCodeLinkReportList = GlazedLists.eventList(new ArrayList());

    public GLAccountLinkSetupState() {
        super("GL Account Links", AllPermissions.CONFIG_INTEGRATIONS, "Modify the GL Account Link\\Setup.");
        this.glAccountLinkPanel = new GLAccountLinkPanel(this.glCodeLinkReportList);
        this.glAccountLinkPanel.tableEdited.connect((Object)this, "tableEdited");
        this.setScreenPanel(this.glAccountLinkPanel);
        this.getScreenPanel().setName("GL Account Links");
        this.getSaveStrategy().setDoPersistentCheckAfterSave(false);
        this.getSaveStrategy().addSaveCancelListener(this);
        if (AccountingIntegrationConfig.getInstance().isGroupBySalesLocation()) {
            InventoryGroupToLocationAccLink.deleteAllRedundantLinks();
            InventoryGroupToLocationAccLink.createAllMissingLinks();
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        List<GLCodeLinkReport> list = GLAccountLinkQueries.getAllGLAccountLinks();
        SequentialComparator comparator = new SequentialComparator();
        comparator.addComparator((Comparator)new PropertyComparator(GLCodeLinkReport.Properties.EXPORT_TYPE));
        comparator.addComparator((Comparator)new PropertyComparator(GLCodeLinkReport.Properties.DESCRIPTION));
        Collections.sort(list, comparator);
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.glCodeLinkReportList, list);
        this.glAccountLinkPanel.refresh();
    }

    public void tableEdited(Object object) {
        this.getSaveStrategy().objectNeedsSaving((GLCodeLinkReport)object);
    }

    @Override
    public void preSave() {
    }

    @Override
    public void preCancel() {
    }

    @Override
    public void postSave() {
        BaseAccountingConfiguration.getInstance().clearCache();
    }
}

