/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.accounting;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ordermate.maps.reports.GLCodeLinkReportMap;
import ordermate.reports.accounting.GLCodeLinkReport;

public class GLAccountQueryBuilder {
    private Map<PropertiedObject.Property, String> selectors = new HashMap<PropertiedObject.Property, String>();
    private String fromTable;
    private Map<Class<? extends PersistentObject>, PropertiedObject.Property> leftJoins = new LinkedHashMap<Class<? extends PersistentObject>, PropertiedObject.Property>();
    private List<String> arbitraryJoins = new ArrayList<String>();
    private List<String> wheres = new ArrayList<String>();
    private String union = null;

    public GLAccountQueryBuilder() {
        this.selectors.put(GLCodeLinkReport.Properties.ID, "@m := @m + 1");
        this.selectors.put(GLCodeLinkReport.Properties.MOD_COUNT, "0");
        this.selectors.put(GLCodeLinkReport.Properties.GL_TYPE, "NULL");
        this.selectors.put(GLCodeLinkReport.Properties.INVENTORY_GROUP, "NULL");
        this.selectors.put(GLCodeLinkReport.Properties.STOCK_AREA, "NULL");
        this.selectors.put(GLCodeLinkReport.Properties.STOCK_GROUP, "NULL");
        this.selectors.put(GLCodeLinkReport.Properties.INVENTORY_CATEGORY, "NULL");
        this.selectors.put(GLCodeLinkReport.Properties.FINANCE_ACCOUNTING_GROUP, "NULL");
        this.selectors.put(GLCodeLinkReport.Properties.SALES_LOCATION, "NULL");
        this.selectors.put(GLCodeLinkReport.Properties.VOUCHER_LINK, "NULL");
    }

    public GLAccountQueryBuilder select(PropertiedObject.Property property, String value) {
        this.selectors.put(property, value);
        return this;
    }

    public GLAccountQueryBuilder from(String fromTable) {
        this.fromTable = fromTable;
        return this;
    }

    public GLAccountQueryBuilder join(Class<? extends PersistentObject> joinClass, PropertiedObject.Property joinProperty) {
        this.leftJoins.put(joinClass, joinProperty);
        return this;
    }

    public GLAccountQueryBuilder join(String arbitraryJoin) {
        this.arbitraryJoins.add(arbitraryJoin);
        return this;
    }

    public GLAccountQueryBuilder where(String where) {
        this.wheres.add(where);
        return this;
    }

    public GLAccountQueryBuilder union(String union) {
        this.union = union;
        return this;
    }

    public String build() {
        ObjectQuery query = new ObjectQuery();
        GLCodeLinkReportMap map = new GLCodeLinkReportMap();
        for (Map.Entry<PropertiedObject.Property, String> entry : this.selectors.entrySet()) {
            query.selectFunc(entry.getValue() + " AS " + map.getColumn(entry.getKey()));
        }
        query.from(this.fromTable, null);
        for (Map.Entry<Object, String> entry : this.leftJoins.entrySet()) {
            query.joinLeft((Class)entry.getKey(), (PropertiedObject.Property)entry.getValue());
        }
        for (String string : this.arbitraryJoins) {
            query.joinFunction(string);
        }
        for (String string : this.wheres) {
            query.whereFunction(string);
        }
        if (this.union != null) {
            query.union(this.union);
        }
        return query.toString() + " ";
    }
}

